/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.inmemory;

import java.io.Serializable;
import java.util.Arrays;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.inmemory.security.Authorizations;
import org.neolumin.vertexium.inmemory.security.ColumnVisibility;
import org.neolumin.vertexium.inmemory.security.VisibilityEvaluator;
import org.neolumin.vertexium.inmemory.security.VisibilityParseException;
import org.neolumin.vertexium.util.ArrayUtils;
import org.neolumin.vertexium.util.Preconditions;

public class InMemoryAuthorizations
implements org.neolumin.vertexium.Authorizations,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String[] authorizations;

    public InMemoryAuthorizations(String ... authorizations) {
        this.authorizations = authorizations;
    }

    public String[] getAuthorizations() {
        return this.authorizations;
    }

    public boolean equals(org.neolumin.vertexium.Authorizations authorizations) {
        return ArrayUtils.intersectsAll((Object[])this.getAuthorizations(), (Object[])authorizations.getAuthorizations());
    }

    public String toString() {
        return Arrays.toString(this.authorizations);
    }

    public boolean canRead(Visibility visibility) {
        Preconditions.checkNotNull((Object)visibility, (Object)"visibility is required");
        if (visibility.getVisibilityString().length() == 0) {
            return true;
        }
        VisibilityEvaluator visibilityEvaluator = new VisibilityEvaluator(new Authorizations(this.getAuthorizations()));
        ColumnVisibility columnVisibility = new ColumnVisibility(visibility.getVisibilityString());
        try {
            return visibilityEvaluator.evaluate(columnVisibility);
        }
        catch (VisibilityParseException e) {
            throw new VertexiumException("could not evaluate visibility " + visibility.getVisibilityString(), (Exception)e);
        }
    }
}

