/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.inmemory;

import java.util.EnumSet;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Direction;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.FetchHint;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.Property;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.inmemory.InMemoryElement;
import org.neolumin.vertexium.mutation.ExistingEdgeMutation;
import org.neolumin.vertexium.mutation.PropertyRemoveMutation;

public class InMemoryEdge
extends InMemoryElement
implements Edge {
    private final String outVertexId;
    private final String inVertexId;
    private String label;

    protected InMemoryEdge(Graph graph, String edgeId, String outVertexId, String inVertexId, String label, Visibility visibility, Iterable<Property> properties, Iterable<PropertyRemoveMutation> propertyRemoveMutations, Iterable<Visibility> hiddenVisibilities, Authorizations authorizations) {
        super(graph, edgeId, visibility, properties, propertyRemoveMutations, hiddenVisibilities, authorizations);
        this.outVertexId = outVertexId;
        this.inVertexId = inVertexId;
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getVertexId(Direction direction) {
        switch (direction) {
            case IN: {
                return this.inVertexId;
            }
            case OUT: {
                return this.outVertexId;
            }
        }
        throw new IllegalArgumentException("Unexpected direction: " + direction);
    }

    public Vertex getVertex(Direction direction, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getVertex(this.getVertexId(direction), fetchHints, authorizations);
    }

    public Vertex getVertex(Direction direction, Authorizations authorizations) {
        return this.getVertex(direction, FetchHint.ALL, authorizations);
    }

    public String getOtherVertexId(String myVertexId) {
        if (this.inVertexId.equals(myVertexId)) {
            return this.outVertexId;
        }
        if (this.outVertexId.equals(myVertexId)) {
            return this.inVertexId;
        }
        throw new VertexiumException("myVertexId does not appear on either the in or the out.");
    }

    public Vertex getOtherVertex(String myVertexId, Authorizations authorizations) {
        return this.getOtherVertex(myVertexId, FetchHint.ALL, authorizations);
    }

    public Vertex getOtherVertex(String myVertexId, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getVertex(this.getOtherVertexId(myVertexId), fetchHints, authorizations);
    }

    public ExistingEdgeMutation prepareMutation() {
        return new ExistingEdgeMutation(this){

            public Edge save(Authorizations authorizations) {
                InMemoryEdge.this.saveExistingElementMutation(this, authorizations);
                return (Edge)this.getElement();
            }
        };
    }

    void setLabel(String newEdgeLabel) {
        this.label = newEdgeLabel;
    }
}

