/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.inmemory;

import java.io.IOException;
import java.io.InputStream;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.Element;
import org.neolumin.vertexium.ElementBase;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.Property;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.inmemory.InMemoryGraph;
import org.neolumin.vertexium.inmemory.InMemoryStreamingPropertyValue;
import org.neolumin.vertexium.inmemory.InMemoryVertex;
import org.neolumin.vertexium.mutation.EdgeMutation;
import org.neolumin.vertexium.mutation.ExistingElementMutationImpl;
import org.neolumin.vertexium.mutation.PropertyRemoveMutation;
import org.neolumin.vertexium.property.MutableProperty;
import org.neolumin.vertexium.property.StreamingPropertyValue;
import org.neolumin.vertexium.util.StreamUtils;

public abstract class InMemoryElement
extends ElementBase {
    protected InMemoryElement(Graph graph, String id, Visibility visibility, Iterable<Property> properties, Iterable<PropertyRemoveMutation> propertyRemoveMutations, Iterable<Visibility> hiddenVisibilities, Authorizations authorizations) {
        super(graph, id, visibility, properties, propertyRemoveMutations, hiddenVisibilities, authorizations);
    }

    public void removeProperty(String key, String name, Authorizations authorizations) {
        Property property = this.removePropertyInternal(key, name);
        if (property != null) {
            this.getGraph().removeProperty((Element)this, property, authorizations);
        }
    }

    public void removeProperty(String name, Authorizations authorizations) {
        Iterable<Property> properties = this.removePropertyInternal(name);
        for (Property property : properties) {
            this.getGraph().removeProperty((Element)this, property, authorizations);
        }
    }

    public void markPropertyHidden(Property property, Visibility visibility, Authorizations authorizations) {
        this.getGraph().markPropertyHidden(this, property, visibility, authorizations);
    }

    public void markPropertyVisible(Property property, Visibility visibility, Authorizations authorizations) {
        this.getGraph().markPropertyVisible(this, property, visibility, authorizations);
    }

    public InMemoryGraph getGraph() {
        return (InMemoryGraph)super.getGraph();
    }

    protected void updatePropertiesInternal(Iterable<Property> properties, Iterable<PropertyRemoveMutation> propertyRemoveMutations) {
        try {
            for (Property property : properties) {
                if (!(property.getValue() instanceof StreamingPropertyValue)) continue;
                StreamingPropertyValue value = (StreamingPropertyValue)property.getValue();
                byte[] valueData = StreamUtils.toBytes((InputStream)value.getInputStream());
                ((MutableProperty)property).setValue((Object)new InMemoryStreamingPropertyValue(valueData, value.getValueType()));
            }
            super.updatePropertiesInternal(properties, propertyRemoveMutations);
        }
        catch (IOException ex) {
            throw new VertexiumException((Exception)ex);
        }
    }

    protected Iterable<Property> removePropertyInternal(String name) {
        return super.removePropertyInternal(name);
    }

    protected Property removePropertyInternal(String key, String name) {
        return super.removePropertyInternal(key, name);
    }

    protected <TElement extends Element> void saveExistingElementMutation(ExistingElementMutationImpl<TElement> mutation, Authorizations authorizations) {
        Iterable properties = mutation.getProperties();
        Iterable propertyRemoves = mutation.getPropertyRemoves();
        this.updatePropertiesInternal(properties, propertyRemoves);
        this.getGraph().saveProperties(mutation.getElement(), properties, propertyRemoves, mutation.getIndexHint(), authorizations);
        if (mutation.getElement() instanceof Edge) {
            EdgeMutation edgeMutation;
            if (mutation.getNewElementVisibility() != null) {
                this.getGraph().alterEdgeVisibility(mutation.getElement().getId(), mutation.getNewElementVisibility());
            }
            this.getGraph().alterEdgePropertyVisibilities(mutation.getElement().getId(), mutation.getAlterPropertyVisibilities(), authorizations);
            this.getGraph().alterEdgePropertyMetadata(mutation.getElement().getId(), mutation.getSetPropertyMetadatas());
            if (mutation instanceof EdgeMutation && (edgeMutation = (EdgeMutation)mutation).getNewEdgeLabel() != null) {
                this.getGraph().alterEdgeLabel(mutation.getElement().getId(), edgeMutation.getNewEdgeLabel());
            }
        } else if (mutation.getElement() instanceof Vertex) {
            if (mutation.getNewElementVisibility() != null) {
                this.getGraph().alterVertexVisibility(mutation.getElement().getId(), mutation.getNewElementVisibility());
            }
            this.getGraph().alterVertexPropertyVisibilities(mutation.getElement().getId(), mutation.getAlterPropertyVisibilities(), authorizations);
            this.getGraph().alterVertexPropertyMetadata(mutation.getElement().getId(), mutation.getSetPropertyMetadatas());
        } else {
            throw new IllegalStateException("Unexpected element type: " + mutation.getElement());
        }
    }

    void setVisibilityInternal(Visibility visibility) {
        super.setVisibility(visibility);
    }

    public void addHiddenVisibility(Visibility visibility) {
        super.addHiddenVisibility(visibility);
    }

    public void removeHiddenVisibility(Visibility visibility) {
        super.removeHiddenVisibility(visibility);
    }

    public boolean canRead(Authorizations authorizations) {
        return this.getVisibility().getVisibilityString().length() <= 0 || authorizations.canRead(this.getVisibility());
    }

    void markPropertyHiddenInternal(Property property, Visibility visibility) {
        if (!(property instanceof MutableProperty)) {
            throw new VertexiumException("Could not mark property hidden. Must be of type " + MutableProperty.class.getName());
        }
        ((MutableProperty)property).addHiddenVisibility(visibility);
    }

    void markPropertyVisibleInternal(Property property, Visibility visibility) {
        if (!(property instanceof MutableProperty)) {
            throw new VertexiumException("Could not mark property visible. Must be of type " + MutableProperty.class.getName());
        }
        ((MutableProperty)property).removeHiddenVisibility(visibility);
    }

    protected void updateExisting(InMemoryVertex newVertex) {
        this.updatePropertiesInternal(newVertex.getProperties(), newVertex.getPropertyRemoveMutations());
    }
}

