/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.inmemory;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Direction;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.EdgeBuilder;
import org.neolumin.vertexium.EdgeBuilderBase;
import org.neolumin.vertexium.EdgeBuilderByVertexId;
import org.neolumin.vertexium.Element;
import org.neolumin.vertexium.FetchHint;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.GraphBaseWithSearchIndex;
import org.neolumin.vertexium.GraphConfiguration;
import org.neolumin.vertexium.GraphMetadataEntry;
import org.neolumin.vertexium.Metadata;
import org.neolumin.vertexium.Property;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.VertexBuilder;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.event.AddEdgeEvent;
import org.neolumin.vertexium.event.AddPropertyEvent;
import org.neolumin.vertexium.event.AddVertexEvent;
import org.neolumin.vertexium.event.GraphEvent;
import org.neolumin.vertexium.event.MarkHiddenEdgeEvent;
import org.neolumin.vertexium.event.MarkHiddenPropertyEvent;
import org.neolumin.vertexium.event.MarkHiddenVertexEvent;
import org.neolumin.vertexium.event.MarkVisibleEdgeEvent;
import org.neolumin.vertexium.event.MarkVisiblePropertyEvent;
import org.neolumin.vertexium.event.MarkVisibleVertexEvent;
import org.neolumin.vertexium.event.RemoveEdgeEvent;
import org.neolumin.vertexium.event.RemovePropertyEvent;
import org.neolumin.vertexium.event.RemoveVertexEvent;
import org.neolumin.vertexium.id.IdGenerator;
import org.neolumin.vertexium.inmemory.InMemoryAuthorizations;
import org.neolumin.vertexium.inmemory.InMemoryEdge;
import org.neolumin.vertexium.inmemory.InMemoryElement;
import org.neolumin.vertexium.inmemory.InMemoryGraphConfiguration;
import org.neolumin.vertexium.inmemory.InMemoryVertex;
import org.neolumin.vertexium.mutation.AlterPropertyVisibility;
import org.neolumin.vertexium.mutation.PropertyRemoveMutation;
import org.neolumin.vertexium.mutation.SetPropertyMetadata;
import org.neolumin.vertexium.search.IndexHint;
import org.neolumin.vertexium.search.SearchIndex;
import org.neolumin.vertexium.util.ConvertingIterable;
import org.neolumin.vertexium.util.IterableUtils;
import org.neolumin.vertexium.util.LookAheadIterable;
import org.neolumin.vertexium.util.Preconditions;

public class InMemoryGraph
extends GraphBaseWithSearchIndex {
    private static final InMemoryGraphConfiguration DEFAULT_CONFIGURATION = new InMemoryGraphConfiguration(new HashMap());
    private final Map<String, InMemoryVertex> vertices;
    private final Map<String, InMemoryEdge> edges;
    private final Map<String, Object> metadata = new HashMap<String, Object>();

    protected InMemoryGraph(InMemoryGraphConfiguration configuration, IdGenerator idGenerator, SearchIndex searchIndex) {
        this(configuration, idGenerator, searchIndex, new HashMap<String, InMemoryVertex>(), new HashMap<String, InMemoryEdge>());
    }

    protected InMemoryGraph(InMemoryGraphConfiguration configuration, IdGenerator idGenerator, SearchIndex searchIndex, Map<String, InMemoryVertex> vertices, Map<String, InMemoryEdge> edges) {
        super((GraphConfiguration)configuration, idGenerator, searchIndex);
        this.vertices = vertices;
        this.edges = edges;
    }

    public static InMemoryGraph create() {
        return InMemoryGraph.create(DEFAULT_CONFIGURATION);
    }

    public static InMemoryGraph create(InMemoryGraphConfiguration config) {
        IdGenerator idGenerator = config.createIdGenerator();
        SearchIndex searchIndex = config.createSearchIndex();
        return InMemoryGraph.create(config, idGenerator, searchIndex);
    }

    public static InMemoryGraph create(InMemoryGraphConfiguration config, IdGenerator idGenerator, SearchIndex searchIndex) {
        InMemoryGraph graph = new InMemoryGraph(config, idGenerator, searchIndex);
        graph.setup();
        return graph;
    }

    public static InMemoryGraph create(Map config) {
        return InMemoryGraph.create(new InMemoryGraphConfiguration(config));
    }

    public VertexBuilder prepareVertex(String vertexId, Visibility visibility) {
        if (vertexId == null) {
            vertexId = this.getIdGenerator().nextId();
        }
        return new VertexBuilder(vertexId, visibility){

            public Vertex save(Authorizations authorizations) {
                InMemoryVertex newVertex = new InMemoryVertex((Graph)InMemoryGraph.this, this.getVertexId(), this.getVisibility(), this.getProperties(), this.getPropertyRemoves(), null, authorizations);
                if (this.getIndexHint() != IndexHint.DO_NOT_INDEX) {
                    InMemoryGraph.this.getSearchIndex().addElement((Graph)InMemoryGraph.this, (Element)newVertex, authorizations);
                }
                InMemoryVertex existingVertex = (InMemoryVertex)InMemoryGraph.this.getVertex(this.getVertexId(), authorizations);
                InMemoryVertex vertex = InMemoryVertex.updateOrCreate(InMemoryGraph.this, existingVertex, newVertex, authorizations);
                InMemoryGraph.this.vertices.put(this.getVertexId(), vertex);
                if (InMemoryGraph.this.hasEventListeners()) {
                    InMemoryGraph.this.fireGraphEvent((GraphEvent)new AddVertexEvent((Graph)InMemoryGraph.this, (Vertex)vertex));
                    for (Property property : this.getProperties()) {
                        InMemoryGraph.this.fireGraphEvent((GraphEvent)new AddPropertyEvent((Graph)InMemoryGraph.this, (Element)vertex, property));
                    }
                    for (PropertyRemoveMutation propertyRemoveMutation : this.getPropertyRemoves()) {
                        InMemoryGraph.this.fireGraphEvent((GraphEvent)new RemovePropertyEvent((Graph)InMemoryGraph.this, (Element)vertex, propertyRemoveMutation));
                    }
                }
                return vertex;
            }
        };
    }

    public Iterable<Vertex> getVertices(EnumSet<FetchHint> fetchHints, final Authorizations authorizations) throws VertexiumException {
        final boolean includeHidden = fetchHints.contains(FetchHint.INCLUDE_HIDDEN);
        return new LookAheadIterable<InMemoryVertex, Vertex>(){

            protected boolean isIncluded(InMemoryVertex src, Vertex vertex) {
                if (!src.canRead(authorizations)) {
                    return false;
                }
                return includeHidden || !src.isHidden(authorizations);
            }

            protected Vertex convert(InMemoryVertex vertex) {
                return InMemoryGraph.this.filteredVertex(vertex, includeHidden, authorizations);
            }

            protected Iterator<InMemoryVertex> createIterator() {
                return InMemoryGraph.this.vertices.values().iterator();
            }
        };
    }

    public void removeVertex(Vertex vertex, Authorizations authorizations) {
        if (!((InMemoryVertex)vertex).canRead(authorizations)) {
            return;
        }
        List edgesToRemove = IterableUtils.toList((Iterable)vertex.getEdges(Direction.BOTH, authorizations));
        for (Edge edgeToRemove : edgesToRemove) {
            this.removeEdge(edgeToRemove, authorizations);
        }
        this.vertices.remove(vertex.getId());
        this.getSearchIndex().removeElement((Graph)this, (Element)vertex, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new RemoveVertexEvent((Graph)this, vertex));
        }
    }

    public void markVertexHidden(Vertex vertex, Visibility visibility, Authorizations authorizations) {
        if (!((InMemoryVertex)vertex).canRead(authorizations)) {
            return;
        }
        List edgesToMarkHidden = IterableUtils.toList((Iterable)vertex.getEdges(Direction.BOTH, authorizations));
        for (Edge edgeToRemove : edgesToMarkHidden) {
            this.markEdgeHidden(edgeToRemove, visibility, authorizations);
        }
        this.vertices.get(vertex.getId()).addHiddenVisibility(visibility);
        this.getSearchIndex().addElement((Graph)this, (Element)vertex, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new MarkHiddenVertexEvent((Graph)this, vertex));
        }
    }

    public void markVertexVisible(Vertex vertex, Visibility visibility, Authorizations authorizations) {
        if (!((InMemoryVertex)vertex).canRead(authorizations)) {
            return;
        }
        List edgesToMarkVisible = IterableUtils.toList((Iterable)vertex.getEdges(Direction.BOTH, FetchHint.ALL_INCLUDING_HIDDEN, authorizations));
        for (Edge edgeToMarkVisible : edgesToMarkVisible) {
            this.markEdgeVisible(edgeToMarkVisible, visibility, authorizations);
        }
        this.vertices.get(vertex.getId()).removeHiddenVisibility(visibility);
        this.getSearchIndex().addElement((Graph)this, (Element)vertex, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new MarkVisibleVertexEvent((Graph)this, vertex));
        }
    }

    public void markPropertyHidden(InMemoryElement element, Property property, Visibility visibility, Authorizations authorizations) {
        if (!element.canRead(authorizations)) {
            return;
        }
        if (element instanceof Vertex) {
            this.vertices.get(element.getId()).markPropertyHiddenInternal(property, visibility);
        } else if (element instanceof Edge) {
            this.edges.get(element.getId()).markPropertyHiddenInternal(property, visibility);
        }
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new MarkHiddenPropertyEvent((Graph)this, (Element)element, property, visibility));
        }
    }

    public void markPropertyVisible(InMemoryElement element, Property property, Visibility visibility, Authorizations authorizations) {
        if (!element.canRead(authorizations)) {
            return;
        }
        if (element instanceof Vertex) {
            this.vertices.get(element.getId()).markPropertyVisibleInternal(property, visibility);
        } else if (element instanceof Edge) {
            this.edges.get(element.getId()).markPropertyVisibleInternal(property, visibility);
        }
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new MarkVisiblePropertyEvent((Graph)this, (Element)element, property, visibility));
        }
    }

    public EdgeBuilderByVertexId prepareEdge(String edgeId, String outVertexId, String inVertexId, String label, Visibility visibility) {
        if (edgeId == null) {
            edgeId = this.getIdGenerator().nextId();
        }
        return new EdgeBuilderByVertexId(edgeId, outVertexId, inVertexId, label, visibility){

            public Edge save(Authorizations authorizations) {
                return InMemoryGraph.this.savePreparedEdge((EdgeBuilderBase)this, this.getOutVertexId(), this.getInVertexId(), authorizations);
            }
        };
    }

    public EdgeBuilder prepareEdge(String edgeId, Vertex outVertex, Vertex inVertex, String label, Visibility visibility) {
        if (edgeId == null) {
            edgeId = this.getIdGenerator().nextId();
        }
        return new EdgeBuilder(edgeId, outVertex, inVertex, label, visibility){

            public Edge save(Authorizations authorizations) {
                return InMemoryGraph.this.savePreparedEdge((EdgeBuilderBase)this, this.getOutVertex().getId(), this.getInVertex().getId(), authorizations);
            }
        };
    }

    private Edge savePreparedEdge(EdgeBuilderBase edgeBuilder, String outVertexId, String inVertexId, Authorizations authorizations) {
        String edgeLabel;
        TreeSet<Property> properties;
        Edge existingEdge = this.getEdge(edgeBuilder.getEdgeId(), authorizations);
        if (existingEdge == null) {
            properties = edgeBuilder.getProperties();
        } else {
            Iterable existingProperties = existingEdge.getProperties();
            Iterable newProperties = edgeBuilder.getProperties();
            properties = new TreeSet<Property>(IterableUtils.toList((Iterable)existingProperties));
            for (Property p : newProperties) {
                properties.remove(p);
                properties.add(p);
            }
        }
        Iterable hiddenVisibilities = null;
        if (existingEdge instanceof InMemoryEdge) {
            hiddenVisibilities = ((InMemoryEdge)existingEdge).getHiddenVisibilities();
        }
        if ((edgeLabel = edgeBuilder.getNewEdgeLabel()) == null) {
            edgeLabel = edgeBuilder.getLabel();
        }
        InMemoryEdge edge = new InMemoryEdge((Graph)this, edgeBuilder.getEdgeId(), outVertexId, inVertexId, edgeLabel, edgeBuilder.getVisibility(), properties, edgeBuilder.getPropertyRemoves(), hiddenVisibilities, authorizations);
        this.edges.put(edgeBuilder.getEdgeId(), edge);
        if (edgeBuilder.getIndexHint() != IndexHint.DO_NOT_INDEX) {
            this.getSearchIndex().addElement((Graph)this, (Element)edge, authorizations);
        }
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new AddEdgeEvent((Graph)this, (Edge)edge));
            for (Property property : edgeBuilder.getProperties()) {
                this.fireGraphEvent((GraphEvent)new AddPropertyEvent((Graph)this, (Element)edge, property));
            }
            for (PropertyRemoveMutation propertyRemoveMutation : edgeBuilder.getPropertyRemoves()) {
                this.fireGraphEvent((GraphEvent)new RemovePropertyEvent((Graph)this, (Element)edge, propertyRemoveMutation));
            }
        }
        return edge;
    }

    public Iterable<Edge> getEdges(EnumSet<FetchHint> fetchHints, final Authorizations authorizations) {
        final boolean includeHidden = fetchHints.contains(FetchHint.INCLUDE_HIDDEN);
        return new LookAheadIterable<InMemoryEdge, Edge>(){

            protected boolean isIncluded(InMemoryEdge src, Edge edge) {
                if (!src.canRead(authorizations)) {
                    return false;
                }
                return includeHidden || !src.isHidden(authorizations);
            }

            protected Edge convert(InMemoryEdge edge) {
                return InMemoryGraph.this.filteredEdge(edge, includeHidden, authorizations);
            }

            protected Iterator<InMemoryEdge> createIterator() {
                return InMemoryGraph.this.edges.values().iterator();
            }
        };
    }

    public void removeEdge(Edge edge, Authorizations authorizations) {
        if (!((InMemoryEdge)edge).canRead(authorizations)) {
            return;
        }
        this.edges.remove(edge.getId());
        this.getSearchIndex().removeElement((Graph)this, (Element)edge, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new RemoveEdgeEvent((Graph)this, edge));
        }
    }

    public Iterable<GraphMetadataEntry> getMetadata() {
        return new ConvertingIterable<Map.Entry<String, Object>, GraphMetadataEntry>(this.metadata.entrySet()){

            protected GraphMetadataEntry convert(Map.Entry<String, Object> o) {
                return new GraphMetadataEntry(o.getKey(), o.getValue());
            }
        };
    }

    public Object getMetadata(String key) {
        return this.metadata.get(key);
    }

    public void setMetadata(String key, Object value) {
        this.metadata.put(key, value);
    }

    public void markEdgeHidden(Edge edge, Visibility visibility, Authorizations authorizations) {
        if (!((InMemoryEdge)edge).canRead(authorizations)) {
            return;
        }
        Vertex inVertex = this.getVertex(edge.getVertexId(Direction.IN), authorizations);
        Preconditions.checkNotNull((Object)inVertex, (Object)("Could not find in vertex: " + edge.getVertexId(Direction.IN)));
        Vertex outVertex = this.getVertex(edge.getVertexId(Direction.OUT), authorizations);
        Preconditions.checkNotNull((Object)outVertex, (Object)("Could not find out vertex: " + edge.getVertexId(Direction.OUT)));
        this.edges.get(edge.getId()).addHiddenVisibility(visibility);
        this.getSearchIndex().addElement((Graph)this, (Element)edge, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new MarkHiddenEdgeEvent((Graph)this, edge));
        }
    }

    public void markEdgeVisible(Edge edge, Visibility visibility, Authorizations authorizations) {
        if (!((InMemoryEdge)edge).canRead(authorizations)) {
            return;
        }
        Vertex inVertex = this.getVertex(edge.getVertexId(Direction.IN), FetchHint.ALL_INCLUDING_HIDDEN, authorizations);
        Preconditions.checkNotNull((Object)inVertex, (Object)("Could not find in vertex: " + edge.getVertexId(Direction.IN)));
        Vertex outVertex = this.getVertex(edge.getVertexId(Direction.OUT), FetchHint.ALL_INCLUDING_HIDDEN, authorizations);
        Preconditions.checkNotNull((Object)outVertex, (Object)("Could not find out vertex: " + edge.getVertexId(Direction.OUT)));
        this.edges.get(edge.getId()).removeHiddenVisibility(visibility);
        this.getSearchIndex().addElement((Graph)this, (Element)edge, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new MarkVisibleEdgeEvent((Graph)this, edge));
        }
    }

    public Authorizations createAuthorizations(String ... auths) {
        return new InMemoryAuthorizations(auths);
    }

    public Iterable<Edge> getEdgesFromVertex(final String vertexId, EnumSet<FetchHint> fetchHints, final Authorizations authorizations) {
        final boolean includeHidden = fetchHints.contains(FetchHint.INCLUDE_HIDDEN);
        return new LookAheadIterable<InMemoryEdge, Edge>(){

            protected boolean isIncluded(InMemoryEdge src, Edge edge) {
                String inVertexId = src.getVertexId(Direction.IN);
                Preconditions.checkNotNull((Object)inVertexId, (Object)"inVertexId was null");
                String outVertexId = src.getVertexId(Direction.OUT);
                Preconditions.checkNotNull((Object)outVertexId, (Object)"outVertexId was null");
                if (!inVertexId.equals(vertexId) && !outVertexId.equals(vertexId)) {
                    return false;
                }
                if (!src.canRead(authorizations)) {
                    return false;
                }
                return includeHidden || !src.isHidden(authorizations);
            }

            protected Edge convert(InMemoryEdge edge) {
                return InMemoryGraph.this.filteredEdge(edge, includeHidden, authorizations);
            }

            protected Iterator<InMemoryEdge> createIterator() {
                return InMemoryGraph.this.edges.values().iterator();
            }
        };
    }

    private boolean canRead(Visibility visibility, Authorizations authorizations) {
        if (visibility.getVisibilityString().length() == 0) {
            return true;
        }
        return authorizations.canRead(visibility);
    }

    public void saveProperties(Element element, Iterable<Property> properties, Iterable<PropertyRemoveMutation> propertyRemoves, IndexHint indexHint, Authorizations authorizations) {
        if (element instanceof Vertex) {
            InMemoryVertex vertex = this.vertices.get(element.getId());
            vertex.updatePropertiesInternal(properties, propertyRemoves);
        } else if (element instanceof Edge) {
            InMemoryEdge edge = this.edges.get(element.getId());
            edge.updatePropertiesInternal(properties, propertyRemoves);
        } else {
            throw new IllegalArgumentException("Unexpected element type: " + element.getClass().getName());
        }
        if (indexHint != IndexHint.DO_NOT_INDEX) {
            for (PropertyRemoveMutation propertyRemoveMutation : propertyRemoves) {
                this.getSearchIndex().removeProperty((Graph)this, element, propertyRemoveMutation.getKey(), propertyRemoveMutation.getName(), propertyRemoveMutation.getVisibility(), authorizations);
            }
            this.getSearchIndex().addElement((Graph)this, element, authorizations);
        }
        if (this.hasEventListeners()) {
            InMemoryElement inMemoryElement = element instanceof Vertex ? (InMemoryElement)this.vertices.get(element.getId()) : (InMemoryElement)this.edges.get(element.getId());
            for (Property property : properties) {
                this.fireGraphEvent((GraphEvent)new AddPropertyEvent((Graph)this, (Element)inMemoryElement, property));
            }
            for (PropertyRemoveMutation propertyRemoveMutation : propertyRemoves) {
                this.fireGraphEvent((GraphEvent)new RemovePropertyEvent((Graph)this, (Element)inMemoryElement, propertyRemoveMutation));
            }
        }
    }

    public void removeProperty(Element element, Property property, Authorizations authorizations) {
        if (element instanceof Vertex) {
            InMemoryVertex vertex = this.vertices.get(element.getId());
            vertex.removePropertyInternal(property.getKey(), property.getName());
        } else if (element instanceof Edge) {
            InMemoryEdge edge = this.edges.get(element.getId());
            edge.removePropertyInternal(property.getKey(), property.getName());
        } else {
            throw new IllegalArgumentException("Unexpected element type: " + element.getClass().getName());
        }
        this.getSearchIndex().removeProperty((Graph)this, element, property, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new RemovePropertyEvent((Graph)this, element, property));
        }
    }

    private Edge filteredEdge(InMemoryEdge edge, boolean includeHidden, Authorizations authorizations) {
        String edgeId = edge.getId();
        String outVertexId = edge.getVertexId(Direction.OUT);
        String inVertexId = edge.getVertexId(Direction.IN);
        String label = edge.getLabel();
        Visibility visibility = edge.getVisibility();
        Iterable hiddenVisibilities = edge.getHiddenVisibilities();
        List<Property> properties = this.filterProperties(edge.getProperties(), includeHidden, authorizations);
        return new InMemoryEdge((Graph)this, edgeId, outVertexId, inVertexId, label, visibility, properties, edge.getPropertyRemoveMutations(), hiddenVisibilities, authorizations);
    }

    private Vertex filteredVertex(InMemoryVertex vertex, boolean includeHidden, Authorizations authorizations) {
        String vertexId = vertex.getId();
        Visibility visibility = vertex.getVisibility();
        Iterable hiddenVisibilities = vertex.getHiddenVisibilities();
        List<Property> properties = this.filterProperties(vertex.getProperties(), includeHidden, authorizations);
        return new InMemoryVertex((Graph)this, vertexId, visibility, properties, vertex.getPropertyRemoveMutations(), hiddenVisibilities, authorizations);
    }

    private List<Property> filterProperties(Iterable<Property> properties, boolean includeHidden, Authorizations authorizations) {
        ArrayList<Property> filteredProperties = new ArrayList<Property>();
        for (Property p : properties) {
            if (!this.canRead(p.getVisibility(), authorizations) || !includeHidden && p.isHidden(authorizations)) continue;
            filteredProperties.add(p);
        }
        return filteredProperties;
    }

    public Map<String, InMemoryVertex> getAllVertices() {
        return this.vertices;
    }

    public Map<String, InMemoryEdge> getAllEdges() {
        return this.edges;
    }

    void alterEdgeVisibility(String edgeId, Visibility newEdgeVisibility) {
        this.edges.get(edgeId).setVisibilityInternal(newEdgeVisibility);
    }

    void alterVertexVisibility(String vertexId, Visibility newVertexVisibility) {
        this.vertices.get(vertexId).setVisibilityInternal(newVertexVisibility);
    }

    void alterEdgePropertyVisibilities(String edgeId, List<AlterPropertyVisibility> alterPropertyVisibilities, Authorizations authorizations) {
        this.alterElementPropertyVisibilities(this.edges.get(edgeId), alterPropertyVisibilities, authorizations);
    }

    void alterVertexPropertyVisibilities(String vertexId, List<AlterPropertyVisibility> alterPropertyVisibilities, Authorizations authorizations) {
        this.alterElementPropertyVisibilities(this.vertices.get(vertexId), alterPropertyVisibilities, authorizations);
    }

    void alterElementPropertyVisibilities(InMemoryElement element, List<AlterPropertyVisibility> alterPropertyVisibilities, Authorizations authorizations) {
        for (AlterPropertyVisibility apv : alterPropertyVisibilities) {
            Property property = element.getProperty(apv.getKey(), apv.getName(), apv.getExistingVisibility());
            if (property == null) {
                throw new VertexiumException("Could not find property " + apv.getKey() + ":" + apv.getName());
            }
            Object value = property.getValue();
            Metadata metadata = property.getMetadata();
            element.removeProperty(apv.getKey(), apv.getName(), authorizations);
            element.addPropertyValue(apv.getKey(), apv.getName(), value, metadata, apv.getVisibility(), authorizations);
        }
    }

    public void alterEdgePropertyMetadata(String edgeId, List<SetPropertyMetadata> setPropertyMetadatas) {
        this.alterElementPropertyMetadata((Element)this.edges.get(edgeId), setPropertyMetadatas);
    }

    public void alterVertexPropertyMetadata(String vertexId, List<SetPropertyMetadata> setPropertyMetadatas) {
        this.alterElementPropertyMetadata((Element)this.vertices.get(vertexId), setPropertyMetadatas);
    }

    private void alterElementPropertyMetadata(Element element, List<SetPropertyMetadata> setPropertyMetadatas) {
        for (SetPropertyMetadata apm : setPropertyMetadatas) {
            Property property = element.getProperty(apm.getPropertyKey(), apm.getPropertyName(), apm.getPropertyVisibility());
            if (property == null) {
                throw new VertexiumException("Could not find property " + apm.getPropertyKey() + ":" + apm.getPropertyName());
            }
            property.getMetadata().add(apm.getMetadataName(), apm.getNewValue(), apm.getMetadataVisibility());
        }
    }

    public boolean isVisibilityValid(Visibility visibility, Authorizations authorizations) {
        return authorizations.canRead(visibility);
    }

    public void clearData() {
        this.vertices.clear();
        this.edges.clear();
        this.getSearchIndex().clearData();
    }

    public void alterEdgeLabel(String edgeId, String newEdgeLabel) {
        InMemoryEdge edge = this.edges.get(edgeId);
        if (edge == null) {
            throw new VertexiumException("Could not find edge " + edgeId);
        }
        edge.setLabel(newEdgeLabel);
    }
}

