/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.inmemory.security;

import org.neolumin.vertexium.inmemory.security.WritableComparator;

abstract class ByteSequence
implements Comparable<ByteSequence> {
    ByteSequence() {
    }

    public abstract byte byteAt(int var1);

    public abstract int length();

    public abstract ByteSequence subSequence(int var1, int var2);

    public abstract byte[] toArray();

    public abstract boolean isBackedByArray();

    public abstract byte[] getBackingArray();

    public abstract int offset();

    public static int compareBytes(ByteSequence bs1, ByteSequence bs2) {
        int minLen = Math.min(bs1.length(), bs2.length());
        for (int i = 0; i < minLen; ++i) {
            int b;
            int a = bs1.byteAt(i) & 0xFF;
            if (a == (b = bs2.byteAt(i) & 0xFF)) continue;
            return a - b;
        }
        return bs1.length() - bs2.length();
    }

    @Override
    public int compareTo(ByteSequence obs) {
        if (this.isBackedByArray() && obs.isBackedByArray()) {
            return WritableComparator.compareBytes(this.getBackingArray(), this.offset(), this.length(), obs.getBackingArray(), obs.offset(), obs.length());
        }
        return ByteSequence.compareBytes(this, obs);
    }

    public boolean equals(Object o) {
        if (o instanceof ByteSequence) {
            ByteSequence obs = (ByteSequence)o;
            if (this == o) {
                return true;
            }
            if (this.length() != obs.length()) {
                return false;
            }
            return this.compareTo(obs) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        if (this.isBackedByArray()) {
            byte[] data = this.getBackingArray();
            int end = this.offset() + this.length();
            for (int i = this.offset(); i < end; ++i) {
                hash = 31 * hash + data[i];
            }
        } else {
            for (int i = 0; i < this.length(); ++i) {
                hash = 31 * hash + this.byteAt(i);
            }
        }
        return hash;
    }
}

