/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.DefinePropertyBuilder;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.EdgeBuilder;
import org.neolumin.vertexium.EdgeBuilderByVertexId;
import org.neolumin.vertexium.ElementBuilder;
import org.neolumin.vertexium.FetchHint;
import org.neolumin.vertexium.GraphMetadataEntry;
import org.neolumin.vertexium.Path;
import org.neolumin.vertexium.ProgressCallback;
import org.neolumin.vertexium.SearchIndexSecurityGranularity;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.VertexBuilder;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.event.GraphEventListener;
import org.neolumin.vertexium.id.IdGenerator;
import org.neolumin.vertexium.query.GraphQuery;
import org.neolumin.vertexium.query.SimilarToGraphQuery;

public interface Graph {
    public Vertex addVertex(Visibility var1, Authorizations var2);

    public Vertex addVertex(String var1, Visibility var2, Authorizations var3);

    public Iterable<Vertex> addVertices(Iterable<ElementBuilder<Vertex>> var1, Authorizations var2);

    public VertexBuilder prepareVertex(Visibility var1);

    public VertexBuilder prepareVertex(String var1, Visibility var2);

    public boolean doesVertexExist(String var1, Authorizations var2);

    public Vertex getVertex(String var1, Authorizations var2);

    public Vertex getVertex(String var1, EnumSet<FetchHint> var2, Authorizations var3);

    public Iterable<Vertex> getVertices(Authorizations var1);

    public Iterable<Vertex> getVertices(EnumSet<FetchHint> var1, Authorizations var2);

    public Map<String, Boolean> doVerticesExist(List<String> var1, Authorizations var2);

    public Iterable<Vertex> getVertices(Iterable<String> var1, Authorizations var2);

    public Iterable<Vertex> getVertices(Iterable<String> var1, EnumSet<FetchHint> var2, Authorizations var3);

    public List<Vertex> getVerticesInOrder(Iterable<String> var1, Authorizations var2);

    public List<Vertex> getVerticesInOrder(Iterable<String> var1, EnumSet<FetchHint> var2, Authorizations var3);

    public void removeVertex(Vertex var1, Authorizations var2);

    public Edge addEdge(Vertex var1, Vertex var2, String var3, Visibility var4, Authorizations var5);

    public Edge addEdge(String var1, Vertex var2, Vertex var3, String var4, Visibility var5, Authorizations var6);

    public Edge addEdge(String var1, String var2, String var3, Visibility var4, Authorizations var5);

    public Edge addEdge(String var1, String var2, String var3, String var4, Visibility var5, Authorizations var6);

    public EdgeBuilder prepareEdge(Vertex var1, Vertex var2, String var3, Visibility var4);

    public EdgeBuilder prepareEdge(String var1, Vertex var2, Vertex var3, String var4, Visibility var5);

    public EdgeBuilderByVertexId prepareEdge(String var1, String var2, String var3, Visibility var4);

    public EdgeBuilderByVertexId prepareEdge(String var1, String var2, String var3, String var4, Visibility var5);

    public boolean doesEdgeExist(String var1, Authorizations var2);

    public Edge getEdge(String var1, Authorizations var2);

    public Edge getEdge(String var1, EnumSet<FetchHint> var2, Authorizations var3);

    public Iterable<Edge> getEdges(Authorizations var1);

    public Iterable<Edge> getEdges(EnumSet<FetchHint> var1, Authorizations var2);

    public Map<String, Boolean> doEdgesExist(List<String> var1, Authorizations var2);

    public Iterable<Edge> getEdges(Iterable<String> var1, Authorizations var2);

    public Iterable<Edge> getEdges(Iterable<String> var1, EnumSet<FetchHint> var2, Authorizations var3);

    public Iterable<String> findRelatedEdges(Iterable<String> var1, Authorizations var2);

    public void removeEdge(Edge var1, Authorizations var2);

    public void removeEdge(String var1, Authorizations var2);

    public GraphQuery query(String var1, Authorizations var2);

    public GraphQuery query(Authorizations var1);

    public boolean isQuerySimilarToTextSupported();

    public SimilarToGraphQuery querySimilarTo(String[] var1, String var2, Authorizations var3);

    public void flush();

    public void shutdown();

    public Iterable<Path> findPaths(Vertex var1, Vertex var2, int var3, Authorizations var4);

    public Iterable<Path> findPaths(String var1, String var2, int var3, Authorizations var4);

    public Iterable<Path> findPaths(Vertex var1, Vertex var2, int var3, ProgressCallback var4, Authorizations var5);

    public Iterable<Path> findPaths(String var1, String var2, int var3, ProgressCallback var4, Authorizations var5);

    public IdGenerator getIdGenerator();

    public boolean isVisibilityValid(Visibility var1, Authorizations var2);

    public void reindex(Authorizations var1);

    public DefinePropertyBuilder defineProperty(String var1);

    public void setMetadata(String var1, Object var2);

    public Object getMetadata(String var1);

    public Iterable<GraphMetadataEntry> getMetadata();

    public boolean isFieldBoostSupported();

    public void clearData();

    public SearchIndexSecurityGranularity getSearchIndexSecurityGranularity();

    public void addGraphEventListener(GraphEventListener var1);

    public void markVertexHidden(Vertex var1, Visibility var2, Authorizations var3);

    public void markVertexVisible(Vertex var1, Visibility var2, Authorizations var3);

    public void markEdgeHidden(Edge var1, Visibility var2, Authorizations var3);

    public void markEdgeVisible(Edge var1, Visibility var2, Authorizations var3);

    public Authorizations createAuthorizations(String ... var1);
}

