/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium;

import java.io.IOException;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.DefinePropertyBuilder;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.GraphBase;
import org.neolumin.vertexium.GraphConfiguration;
import org.neolumin.vertexium.GraphMetadataEntry;
import org.neolumin.vertexium.PropertyDefinition;
import org.neolumin.vertexium.SearchIndexSecurityGranularity;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.id.IdGenerator;
import org.neolumin.vertexium.query.GraphQuery;
import org.neolumin.vertexium.query.SimilarToGraphQuery;
import org.neolumin.vertexium.search.SearchIndex;
import org.neolumin.vertexium.util.ToElementIterable;

public abstract class GraphBaseWithSearchIndex
extends GraphBase
implements Graph {
    public static final String METADATA_DEFINE_PROPERTY_PREFIX = "defineProperty.";
    public static final String METADATA_ID_GENERATOR_CLASSNAME = "idGenerator.classname";
    private final GraphConfiguration configuration;
    private final IdGenerator idGenerator;
    private SearchIndex searchIndex;
    private boolean foundIdGeneratorClassnameInMetadata;

    protected GraphBaseWithSearchIndex(GraphConfiguration configuration, IdGenerator idGenerator, SearchIndex searchIndex) {
        this.configuration = configuration;
        this.idGenerator = idGenerator;
        this.searchIndex = searchIndex;
    }

    protected void setup() {
        this.setupGraphMetadata();
    }

    protected void setupGraphMetadata() {
        this.foundIdGeneratorClassnameInMetadata = false;
        for (GraphMetadataEntry graphMetadataEntry : this.getMetadata()) {
            this.setupGraphMetadata(graphMetadataEntry);
        }
        if (!this.foundIdGeneratorClassnameInMetadata) {
            this.setMetadata(METADATA_ID_GENERATOR_CLASSNAME, this.idGenerator.getClass().getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setupGraphMetadata(GraphMetadataEntry graphMetadataEntry) {
        Object v = graphMetadataEntry.getValue();
        if (graphMetadataEntry.getKey().startsWith(METADATA_DEFINE_PROPERTY_PREFIX)) {
            if (!(v instanceof PropertyDefinition)) throw new VertexiumException("Invalid property definition metadata: " + graphMetadataEntry.getKey() + " expected " + PropertyDefinition.class.getName() + " found " + v.getClass().getName());
            this.setupPropertyDefinition((PropertyDefinition)v);
            return;
        } else {
            if (!graphMetadataEntry.getKey().equals(METADATA_ID_GENERATOR_CLASSNAME)) return;
            if (!(v instanceof String)) throw new VertexiumException("Invalid idGenerator.classname expected String found " + v.getClass().getName());
            String idGeneratorClassname = (String)graphMetadataEntry.getValue();
            if (!idGeneratorClassname.equals(this.idGenerator.getClass().getName())) return;
            this.foundIdGeneratorClassnameInMetadata = true;
        }
    }

    protected void setupPropertyDefinition(PropertyDefinition propertyDefinition) {
        try {
            this.getSearchIndex().addPropertyDefinition(propertyDefinition);
        }
        catch (IOException e) {
            throw new VertexiumException("Could not add property definition to search index", e);
        }
    }

    @Override
    public GraphQuery query(Authorizations authorizations) {
        return this.getSearchIndex().queryGraph(this, null, authorizations);
    }

    @Override
    public GraphQuery query(String queryString, Authorizations authorizations) {
        return this.getSearchIndex().queryGraph(this, queryString, authorizations);
    }

    @Override
    public boolean isQuerySimilarToTextSupported() {
        return this.getSearchIndex().isQuerySimilarToTextSupported();
    }

    @Override
    public SimilarToGraphQuery querySimilarTo(String[] fields, String text, Authorizations authorizations) {
        return this.getSearchIndex().querySimilarTo(this, fields, text, authorizations);
    }

    @Override
    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public GraphConfiguration getConfiguration() {
        return this.configuration;
    }

    public SearchIndex getSearchIndex() {
        return this.searchIndex;
    }

    @Override
    public void reindex(Authorizations authorizations) {
        this.reindexVertices(authorizations);
        this.reindexEdges(authorizations);
    }

    protected void reindexVertices(Authorizations authorizations) {
        this.searchIndex.addElements(this, new ToElementIterable<Vertex>(this.getVertices(authorizations)), authorizations);
    }

    private void reindexEdges(Authorizations authorizations) {
        this.searchIndex.addElements(this, new ToElementIterable<Edge>(this.getEdges(authorizations)), authorizations);
    }

    @Override
    public void flush() {
        if (this.getSearchIndex() != null) {
            this.searchIndex.flush();
        }
    }

    @Override
    public void shutdown() {
        this.flush();
        if (this.getSearchIndex() != null) {
            this.searchIndex.shutdown();
            this.searchIndex = null;
        }
    }

    @Override
    public DefinePropertyBuilder defineProperty(final String propertyName) {
        return new DefinePropertyBuilder(propertyName){

            @Override
            public PropertyDefinition define() {
                PropertyDefinition propertyDefinition = super.define();
                try {
                    GraphBaseWithSearchIndex.this.getSearchIndex().addPropertyDefinition(propertyDefinition);
                }
                catch (IOException e) {
                    throw new VertexiumException("Could not add property definition to search index", e);
                }
                GraphBaseWithSearchIndex.this.setMetadata(GraphBaseWithSearchIndex.METADATA_DEFINE_PROPERTY_PREFIX + propertyName, propertyDefinition);
                return propertyDefinition;
            }
        };
    }

    @Override
    public boolean isFieldBoostSupported() {
        return this.getSearchIndex().isFieldBoostSupported();
    }

    @Override
    public SearchIndexSecurityGranularity getSearchIndexSecurityGranularity() {
        return this.getSearchIndex().getSearchIndexSecurityGranularity();
    }
}

