/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.path;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Direction;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.Path;
import org.neolumin.vertexium.ProgressCallback;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.path.PathFindingAlgorithm;
import org.neolumin.vertexium.util.IterableUtils;

public class RecursivePathFindingAlgorithm
implements PathFindingAlgorithm {
    @Override
    public Iterable<Path> findPaths(Graph graph, Vertex sourceVertex, Vertex destVertex, int hops, ProgressCallback progressCallback, Authorizations authorizations) {
        progressCallback.progress(0.0, ProgressCallback.Step.FINDING_PATH);
        HashSet<String> seenVertices = new HashSet<String>();
        seenVertices.add(sourceVertex.getId());
        Path startPath = new Path(sourceVertex.getId());
        ArrayList<Path> foundPaths = new ArrayList<Path>();
        if (hops == 2) {
            this.findPathsSetIntersection(foundPaths, sourceVertex, destVertex, progressCallback, authorizations);
        } else {
            this.findPathsRecursive(foundPaths, sourceVertex, destVertex, hops, hops, seenVertices, startPath, progressCallback, authorizations);
        }
        progressCallback.progress(1.0, ProgressCallback.Step.COMPLETE);
        return foundPaths;
    }

    private void findPathsSetIntersection(List<Path> foundPaths, Vertex sourceVertex, Vertex destVertex, ProgressCallback progressCallback, Authorizations authorizations) {
        String sourceVertexId = sourceVertex.getId();
        String destVertexId = destVertex.getId();
        progressCallback.progress(0.1, ProgressCallback.Step.SEARCHING_SOURCE_VERTEX_EDGES);
        Set<String> sourceVertexConnectedVertexIds = IterableUtils.toSet(sourceVertex.getVertexIds(Direction.BOTH, authorizations));
        progressCallback.progress(0.3, ProgressCallback.Step.SEARCHING_DESTINATION_VERTEX_EDGES);
        Set<String> destVertexConnectedVertexIds = IterableUtils.toSet(destVertex.getVertexIds(Direction.BOTH, authorizations));
        progressCallback.progress(0.6, ProgressCallback.Step.MERGING_EDGES);
        sourceVertexConnectedVertexIds.retainAll(destVertexConnectedVertexIds);
        progressCallback.progress(0.9, ProgressCallback.Step.ADDING_PATHS);
        for (String connectedVertexId : sourceVertexConnectedVertexIds) {
            foundPaths.add(new Path(sourceVertexId, connectedVertexId, destVertexId));
        }
    }

    private void findPathsRecursive(List<Path> foundPaths, Vertex sourceVertex, Vertex destVertex, int hops, int totalHops, Set<String> seenVertices, Path currentPath, ProgressCallback progressCallback, Authorizations authorizations) {
        boolean firstLevelRecursion = hops == totalHops;
        seenVertices.add(sourceVertex.getId());
        if (sourceVertex.getId().equals(destVertex.getId())) {
            foundPaths.add(currentPath);
        } else if (hops > 0) {
            Iterable<Vertex> vertices = sourceVertex.getVertices(Direction.BOTH, authorizations);
            int vertexCount = 0;
            if (firstLevelRecursion) {
                vertices = IterableUtils.toList(vertices);
                vertexCount = ((List)vertices).size();
            }
            int i = 0;
            for (Vertex child : vertices) {
                if (firstLevelRecursion) {
                    double progressPercent = (double)i / (double)vertexCount;
                    progressCallback.progress(progressPercent, ProgressCallback.Step.SEARCHING_EDGES, i + 1, vertexCount);
                }
                if (!seenVertices.contains(child.getId())) {
                    this.findPathsRecursive(foundPaths, child, destVertex, hops - 1, totalHops, seenVertices, new Path(currentPath, child.getId()), progressCallback, authorizations);
                }
                ++i;
            }
        }
        seenVertices.remove(sourceVertex.getId());
    }
}

