/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.property;

import java.util.HashSet;
import java.util.Set;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Metadata;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.property.MutableProperty;

public class MutablePropertyImpl
extends MutableProperty {
    private final String key;
    private final String name;
    private Set<Visibility> hiddenVisibilities;
    private Object value;
    private Visibility visibility;
    private final Metadata metadata;

    public MutablePropertyImpl(String key, String name, Object value, Metadata metadata, Set<Visibility> hiddenVisibilities, Visibility visibility) {
        if (metadata == null) {
            metadata = new Metadata();
        }
        this.key = key;
        this.name = name;
        this.value = value;
        this.metadata = metadata;
        this.visibility = visibility;
        this.hiddenVisibilities = hiddenVisibilities;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Iterable<Visibility> getHiddenVisibilities() {
        return this.hiddenVisibilities;
    }

    @Override
    public boolean isHidden(Authorizations authorizations) {
        if (this.hiddenVisibilities != null) {
            for (Visibility v : this.getHiddenVisibilities()) {
                if (!authorizations.canRead(v)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public void addHiddenVisibility(Visibility visibility) {
        if (this.hiddenVisibilities == null) {
            this.hiddenVisibilities = new HashSet<Visibility>();
        }
        this.hiddenVisibilities.add(visibility);
    }

    @Override
    public void removeHiddenVisibility(Visibility visibility) {
        if (this.hiddenVisibilities == null) {
            this.hiddenVisibilities = new HashSet<Visibility>();
        }
        this.hiddenVisibilities.remove(visibility);
    }

    @Override
    protected void addMetadata(String key, Object value, Visibility visibility) {
        this.metadata.add(key, value, visibility);
    }

    @Override
    protected void removeMetadata(String key, Visibility visibility) {
        this.metadata.remove(key, visibility);
    }
}

