/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.type;

import java.io.Serializable;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.type.GeoShape;

public class GeoPoint
implements Serializable,
GeoShape,
Comparable<GeoPoint> {
    private static final long serialVersionUID = 1L;
    private static final double COMPARE_TOLERANCE = 1.0E-5;
    private static double EARTH_RADIUS = 6371.0;
    private double latitude;
    private double longitude;
    private Double altitude;
    private String description;

    protected GeoPoint() {
        this.latitude = 0.0;
        this.longitude = 0.0;
        this.altitude = null;
        this.description = null;
    }

    public GeoPoint(double latitude, double longitude, Double altitude, String description) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
        this.description = description;
    }

    public GeoPoint(double latitude, double longitude, Double altitude) {
        this(latitude, longitude, altitude, null);
    }

    public GeoPoint(double latitude, double longitude) {
        this(latitude, longitude, null, null);
    }

    public GeoPoint(double latitude, double longitude, String description) {
        this(latitude, longitude, null, description);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public Double getAltitude() {
        return this.altitude;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "(" + this.getLatitude() + ", " + this.getLongitude() + ")";
    }

    @Override
    public boolean within(GeoShape geoShape) {
        throw new VertexiumException("Not implemented for argument type " + geoShape.getClass().getName());
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.latitude) ^ Double.doubleToLongBits(this.latitude) >>> 32);
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.longitude) ^ Double.doubleToLongBits(this.longitude) >>> 32);
        hash = 47 * hash + (this.altitude != null ? this.altitude.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoPoint other = (GeoPoint)obj;
        if (Double.doubleToLongBits(this.latitude) != Double.doubleToLongBits(other.latitude)) {
            return false;
        }
        if (Double.doubleToLongBits(this.longitude) != Double.doubleToLongBits(other.longitude)) {
            return false;
        }
        return this.altitude == other.altitude || this.altitude != null && this.altitude.equals(other.altitude);
    }

    public static double distanceBetween(GeoPoint geoPoint1, GeoPoint geoPoint2) {
        return GeoPoint.distanceBetween(geoPoint1.getLatitude(), geoPoint1.getLongitude(), geoPoint2.getLatitude(), geoPoint2.getLongitude());
    }

    public static double distanceBetween(double latitude1, double longitude1, double latitude2, double longitude2) {
        double dLat = GeoPoint.toRadians(latitude2 - latitude1);
        double dLon = GeoPoint.toRadians(longitude2 - longitude1);
        latitude1 = GeoPoint.toRadians(latitude1);
        latitude2 = GeoPoint.toRadians(latitude2);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0) * Math.cos(latitude1) * Math.cos(latitude2);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return EARTH_RADIUS * c;
    }

    private static double toRadians(double v) {
        return v * Math.PI / 180.0;
    }

    @Override
    public int compareTo(GeoPoint other) {
        int i = GeoPoint.compare(this.getLatitude(), other.getLatitude());
        if (i != 0) {
            return i;
        }
        i = GeoPoint.compare(this.getLongitude(), other.getLongitude());
        if (i != 0) {
            return i;
        }
        if (this.getAltitude() != null && other.getAltitude() != null) {
            return GeoPoint.compare(this.getAltitude(), other.getAltitude());
        }
        if (this.getAltitude() != null) {
            return 1;
        }
        if (other.getAltitude() != null) {
            return -1;
        }
        return 0;
    }

    private static int compare(double d1, double d2) {
        if (Math.abs(d1 - d2) < 1.0E-5) {
            return 0;
        }
        if (d1 < d2) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        return 0;
    }
}

