/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.elasticsearch;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.PropertyDefinition;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.elasticsearch.AuthorizationFilterBuilder;
import org.neolumin.vertexium.elasticsearch.ElasticSearchGraphQueryBase;
import org.neolumin.vertexium.elasticsearch.score.ScoringStrategy;
import org.neolumin.vertexium.query.GeohashQueryItem;
import org.neolumin.vertexium.query.GraphQueryWithGeohashAggregation;
import org.neolumin.vertexium.query.GraphQueryWithHistogramAggregation;
import org.neolumin.vertexium.query.GraphQueryWithTermsAggregation;
import org.neolumin.vertexium.query.HistogramQueryItem;
import org.neolumin.vertexium.query.TermsQueryItem;

public class ElasticSearchGraphQuery
extends ElasticSearchGraphQueryBase
implements GraphQueryWithHistogramAggregation,
GraphQueryWithTermsAggregation,
GraphQueryWithGeohashAggregation {
    private final List<HistogramQueryItem> histogramQueryItems = new ArrayList<HistogramQueryItem>();
    private final List<TermsQueryItem> termsQueryItems = new ArrayList<TermsQueryItem>();
    private final List<GeohashQueryItem> geohashQueryItems = new ArrayList<GeohashQueryItem>();

    public ElasticSearchGraphQuery(TransportClient client, String[] indicesToQuery, Graph graph, String queryString, Map<String, PropertyDefinition> propertyDefinitions, ScoringStrategy scoringStrategy, Authorizations authorizations) {
        super(client, indicesToQuery, graph, queryString, propertyDefinitions, scoringStrategy, false, authorizations);
    }

    public ElasticSearchGraphQuery(TransportClient client, String[] indicesToQuery, Graph graph, String[] similarToFields, String similarToText, Map<String, PropertyDefinition> propertyDefinitions, ScoringStrategy scoringStrategy, Authorizations authorizations) {
        super(client, indicesToQuery, graph, similarToFields, similarToText, propertyDefinitions, scoringStrategy, false, authorizations);
    }

    protected List<FilterBuilder> getFilters(String elementType) {
        List filters = super.getFilters(elementType);
        AuthorizationFilterBuilder authorizationFilterBuilder = new AuthorizationFilterBuilder(this.getParameters().getAuthorizations().getAuthorizations());
        filters.add(authorizationFilterBuilder);
        return filters;
    }

    public GraphQueryWithHistogramAggregation addHistogramAggregation(String aggregationName, String fieldName, String interval) {
        this.histogramQueryItems.add(new HistogramQueryItem(aggregationName, fieldName, interval));
        return this;
    }

    public GraphQueryWithTermsAggregation addTermsAggregation(String aggregationName, String fieldName) {
        this.termsQueryItems.add(new TermsQueryItem(aggregationName, fieldName));
        return this;
    }

    public GraphQueryWithGeohashAggregation addGeohashAggregation(String aggregationName, String fieldName, int precision) {
        this.geohashQueryItems.add(new GeohashQueryItem(aggregationName, fieldName, precision));
        return this;
    }

    protected SearchRequestBuilder getSearchRequestBuilder(List<FilterBuilder> filters, QueryBuilder queryBuilder) {
        TermsBuilder agg;
        SearchRequestBuilder searchRequestBuilder = super.getSearchRequestBuilder(filters, queryBuilder);
        for (HistogramQueryItem histogramQueryItem : this.histogramQueryItems) {
            DateHistogramBuilder agg2;
            PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinitions().get(histogramQueryItem.getFieldName());
            if (propertyDefinition == null) {
                throw new VertexiumException("Could not find mapping for property: " + histogramQueryItem.getFieldName());
            }
            Class propertyDataType = propertyDefinition.getDataType();
            if (propertyDataType == Date.class) {
                agg2 = AggregationBuilders.dateHistogram((String)histogramQueryItem.getAggregationName());
                agg2.field(histogramQueryItem.getFieldName());
                agg2.interval(Long.parseLong(histogramQueryItem.getInterval()));
                searchRequestBuilder.addAggregation((AbstractAggregationBuilder)agg2);
                continue;
            }
            agg2 = AggregationBuilders.histogram((String)histogramQueryItem.getAggregationName());
            agg2.field(histogramQueryItem.getFieldName());
            agg2.interval(Long.parseLong(histogramQueryItem.getInterval()));
            searchRequestBuilder.addAggregation((AbstractAggregationBuilder)agg2);
        }
        for (TermsQueryItem termsQueryItem : this.termsQueryItems) {
            agg = AggregationBuilders.terms((String)termsQueryItem.getAggregationName());
            agg.field(termsQueryItem.getFieldName());
            searchRequestBuilder.addAggregation((AbstractAggregationBuilder)agg);
        }
        for (GeohashQueryItem geohashQueryItem : this.geohashQueryItems) {
            agg = AggregationBuilders.geohashGrid((String)geohashQueryItem.getAggregationName());
            agg.field(geohashQueryItem.getFieldName());
            agg.precision(geohashQueryItem.getPrecision());
            searchRequestBuilder.addAggregation((AbstractAggregationBuilder)agg);
        }
        return searchRequestBuilder;
    }
}

