/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.elasticsearch;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.DateOnly;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.Element;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.GraphConfiguration;
import org.neolumin.vertexium.Property;
import org.neolumin.vertexium.PropertyDefinition;
import org.neolumin.vertexium.SearchIndexSecurityGranularity;
import org.neolumin.vertexium.TextIndexHint;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.elasticsearch.ElasticSearchGraphQuery;
import org.neolumin.vertexium.elasticsearch.ElasticSearchSearchIndexBase;
import org.neolumin.vertexium.elasticsearch.IndexInfo;
import org.neolumin.vertexium.property.StreamingPropertyValue;
import org.neolumin.vertexium.query.GraphQuery;
import org.neolumin.vertexium.query.SimilarToGraphQuery;
import org.neolumin.vertexium.search.SearchIndex;
import org.neolumin.vertexium.type.GeoPoint;
import org.neolumin.vertexium.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchSearchIndex
extends ElasticSearchSearchIndexBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchSearchIndexBase.class);

    public ElasticSearchSearchIndex(GraphConfiguration config) {
        super(config);
    }

    public void addElement(Graph graph, Element element, Authorizations authorizations) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("addElement: " + element.getId());
        }
        if (!this.getConfig().isIndexEdges() && element instanceof Edge) {
            return;
        }
        IndexInfo indexInfo = this.addPropertiesToIndex(element, element.getProperties());
        try {
            XContentBuilder jsonBuilder = this.buildJsonContentFromElement(graph, indexInfo, element, authorizations);
            IndexResponse response = (IndexResponse)this.getClient().prepareIndex(indexInfo.getIndexName(), "element", element.getId()).setSource(jsonBuilder.endObject()).execute().actionGet();
            if (response.getId() == null) {
                throw new VertexiumException("Could not index document " + element.getId());
            }
            if (this.getConfig().isAutoFlush()) {
                this.flush();
            }
        }
        catch (Exception e) {
            throw new VertexiumException("Could not add element", e);
        }
        this.getConfig().getScoringStrategy().addElement((SearchIndex)this, graph, element, authorizations);
    }

    public void addElementToBulkRequest(Graph graph, BulkRequest bulkRequest, IndexInfo indexInfo, Element element, Authorizations authorizations) {
        try {
            XContentBuilder json = this.buildJsonContentFromElement(graph, indexInfo, element, authorizations);
            IndexRequest indexRequest = new IndexRequest(indexInfo.getIndexName(), "element", element.getId()).source(json);
            bulkRequest.add(indexRequest);
        }
        catch (IOException ex) {
            throw new VertexiumException("Could not add element to bulk request", (Exception)ex);
        }
    }

    public void removeElement(Graph graph, Element element, Authorizations authorizations) {
        String indexName = this.getIndexName(element);
        String id = element.getId();
        LOGGER.debug("deleting document " + id);
        DeleteResponse deleteResponse = (DeleteResponse)this.getClient().delete((DeleteRequest)this.getClient().prepareDelete(indexName, "element", id).request()).actionGet();
        if (!deleteResponse.isFound()) {
            throw new VertexiumException("Could not remove element " + element.getId());
        }
    }

    public String createJsonForElement(Graph graph, Element element, Authorizations authorizations) {
        try {
            String indexName = this.getIndexName(element);
            IndexInfo indexInfo = this.ensureIndexCreatedAndInitialized(indexName, this.getConfig().isStoreSourceData());
            return this.buildJsonContentFromElement(graph, indexInfo, element, authorizations).string();
        }
        catch (Exception e) {
            throw new VertexiumException("Could not create JSON for element", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XContentBuilder buildJsonContentFromElement(Graph graph, IndexInfo indexInfo, Element element, Authorizations authorizations) throws IOException {
        XContentBuilder jsonBuilder = XContentFactory.jsonBuilder().startObject();
        if ((element = this.requeryWithAuthsAndMergedElement(graph, element, authorizations)) instanceof Vertex) {
            jsonBuilder.field("__elementType", "vertex");
            this.getConfig().getScoringStrategy().addFieldsToVertexDocument((SearchIndex)this, jsonBuilder, (Vertex)element, null, authorizations);
        } else {
            if (!(element instanceof Edge)) throw new VertexiumException("Unexpected element type " + element.getClass().getName());
            jsonBuilder.field("__elementType", "edge");
            this.getConfig().getScoringStrategy().addFieldsToEdgeDocument((SearchIndex)this, jsonBuilder, (Edge)element, null, authorizations);
        }
        HashSet<String> visibilityStrings = new HashSet<String>();
        visibilityStrings.add(element.getVisibility().getVisibilityString());
        for (Property property : element.getProperties()) {
            visibilityStrings.add(property.getVisibility().getVisibilityString());
            Object propertyValue = property.getValue();
            if (propertyValue != null && this.shouldIgnoreType(propertyValue.getClass())) continue;
            if (propertyValue instanceof GeoPoint) {
                GeoPoint geoPoint = (GeoPoint)propertyValue;
                HashMap<String, Double> propertyValueMap = new HashMap<String, Double>();
                propertyValueMap.put("lat", geoPoint.getLatitude());
                propertyValueMap.put("lon", geoPoint.getLongitude());
                jsonBuilder.field(property.getName() + "_geo", propertyValueMap);
                if (geoPoint.getDescription() == null) continue;
                jsonBuilder.field(property.getName(), geoPoint.getDescription());
                continue;
            }
            if (propertyValue instanceof StreamingPropertyValue) {
                PropertyDefinition propertyDefinition;
                StreamingPropertyValue streamingPropertyValue = (StreamingPropertyValue)propertyValue;
                if (!streamingPropertyValue.isSearchIndex() || (propertyDefinition = (PropertyDefinition)indexInfo.getPropertyDefinitions().get(property.getName())) != null && !propertyDefinition.getTextIndexHints().contains(TextIndexHint.FULL_TEXT)) continue;
                Class valueType = streamingPropertyValue.getValueType();
                if (valueType != String.class) throw new VertexiumException("Unhandled StreamingPropertyValue type: " + valueType.getName());
                InputStream in = streamingPropertyValue.getInputStream();
                propertyValue = StreamUtils.toString((InputStream)in);
            } else if (propertyValue instanceof String) {
                PropertyDefinition propertyDefinition = (PropertyDefinition)indexInfo.getPropertyDefinitions().get(property.getName());
                if (propertyDefinition == null || propertyDefinition.getTextIndexHints().contains(TextIndexHint.EXACT_MATCH)) {
                    jsonBuilder.field(property.getName() + "_exactMatch", propertyValue);
                }
                if (propertyDefinition != null && !propertyDefinition.getTextIndexHints().contains(TextIndexHint.FULL_TEXT)) continue;
                jsonBuilder.field(property.getName(), propertyValue);
                continue;
            }
            if (propertyValue instanceof DateOnly) {
                propertyValue = ((DateOnly)propertyValue).getDate();
            }
            jsonBuilder.field(property.getName(), propertyValue);
        }
        String visibilityString = Visibility.and(visibilityStrings).getVisibilityString();
        jsonBuilder.field("__visibility", visibilityString);
        return jsonBuilder;
    }

    private Element requeryWithAuthsAndMergedElement(Graph graph, Element element, Authorizations authorizations) {
        Vertex existingElement;
        if (element instanceof Vertex) {
            existingElement = graph.getVertex(element.getId(), authorizations);
        } else if (element instanceof Edge) {
            existingElement = graph.getEdge(element.getId(), authorizations);
        } else {
            throw new VertexiumException("Unexpected element type " + element.getClass().getName());
        }
        if (existingElement == null) {
            return element;
        }
        LOGGER.debug("Reindexing element " + element.getId());
        existingElement.mergeProperties(element);
        return existingElement;
    }

    protected void addPropertyToIndex(IndexInfo indexInfo, String propertyName, Class dataType, boolean analyzed, Double boost) throws IOException {
        if (indexInfo.isPropertyDefined(propertyName)) {
            return;
        }
        if (this.shouldIgnoreType(dataType)) {
            return;
        }
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("element").startObject("properties").startObject(propertyName);
        this.addTypeToMapping(mapping, propertyName, dataType, analyzed, boost);
        mapping.endObject().endObject().endObject().endObject();
        PutMappingResponse response = (PutMappingResponse)this.getClient().admin().indices().preparePutMapping(new String[]{indexInfo.getIndexName()}).setIgnoreConflicts(false).setType("element").setSource(mapping).execute().actionGet();
        LOGGER.debug(response.toString());
        indexInfo.addPropertyDefinition(propertyName, new PropertyDefinition(propertyName, dataType, TextIndexHint.ALL));
    }

    public GraphQuery queryGraph(Graph graph, String queryString, Authorizations authorizations) {
        return new ElasticSearchGraphQuery(this.getClient(), this.getConfig().getIndicesToQuery(), graph, queryString, this.getAllPropertyDefinitions(), this.getConfig().getScoringStrategy(), authorizations);
    }

    public SimilarToGraphQuery querySimilarTo(Graph graph, String[] similarToFields, String similarToText, Authorizations authorizations) {
        return new ElasticSearchGraphQuery(this.getClient(), this.getConfig().getIndicesToQuery(), graph, similarToFields, similarToText, this.getAllPropertyDefinitions(), this.getConfig().getScoringStrategy(), authorizations);
    }

    public SearchIndexSecurityGranularity getSearchIndexSecurityGranularity() {
        return SearchIndexSecurityGranularity.DOCUMENT;
    }
}

