/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.inmemory;

import java.util.EnumSet;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Direction;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.FetchHint;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.Property;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.inmemory.InMemoryElement;
import org.neolumin.vertexium.inmemory.InMemoryGraph;
import org.neolumin.vertexium.inmemory.util.EdgeToEdgeIdIterable;
import org.neolumin.vertexium.mutation.ExistingElementMutation;
import org.neolumin.vertexium.mutation.ExistingElementMutationImpl;
import org.neolumin.vertexium.mutation.PropertyRemoveMutation;
import org.neolumin.vertexium.query.VertexQuery;
import org.neolumin.vertexium.util.ConvertingIterable;
import org.neolumin.vertexium.util.FilterIterable;
import org.neolumin.vertexium.util.IterableUtils;

public class InMemoryVertex
extends InMemoryElement
implements Vertex {
    public InMemoryVertex(Graph graph, String id, Visibility visibility, Iterable<Property> properties, Iterable<PropertyRemoveMutation> propertyRemoveMutations, Iterable<Visibility> hiddenVisibilities, Authorizations authorizations) {
        super(graph, id, visibility, properties, propertyRemoveMutations, hiddenVisibilities, authorizations);
    }

    public Iterable<Edge> getEdges(Direction direction, Authorizations authorizations) {
        return this.getEdges(direction, FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(final Direction direction, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return new FilterIterable<Edge>(this.getGraph().getEdgesFromVertex(this.getId(), fetchHints, authorizations)){

            protected boolean isIncluded(Edge edge) {
                switch (direction) {
                    case IN: {
                        return edge.getVertexId(Direction.IN).equals(InMemoryVertex.this.getId());
                    }
                    case OUT: {
                        return edge.getVertexId(Direction.OUT).equals(InMemoryVertex.this.getId());
                    }
                }
                return true;
            }
        };
    }

    public Iterable<String> getEdgeIds(Direction direction, Authorizations authorizations) {
        return new EdgeToEdgeIdIterable(this.getEdges(direction, authorizations));
    }

    public Iterable<Edge> getEdges(Direction direction, String label, Authorizations authorizations) {
        return this.getEdges(direction, label, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(Direction direction, String label, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getEdges(direction, this.labelToArrayOrNull(label), authorizations);
    }

    public Iterable<String> getEdgeIds(Direction direction, String label, Authorizations authorizations) {
        return new EdgeToEdgeIdIterable(this.getEdges(direction, label, authorizations));
    }

    public Iterable<Edge> getEdges(Direction direction, String[] labels, Authorizations authorizations) {
        return this.getEdges(direction, labels, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(Direction direction, final String[] labels, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return new FilterIterable<Edge>(this.getEdges(direction, authorizations)){

            protected boolean isIncluded(Edge edge) {
                for (String label : labels) {
                    if (!label.equals(edge.getLabel())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public Iterable<String> getEdgeIds(Direction direction, String[] labels, Authorizations authorizations) {
        return new EdgeToEdgeIdIterable(this.getEdges(direction, labels, authorizations));
    }

    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, Authorizations authorizations) {
        return this.getEdges(otherVertex, direction, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(final Vertex otherVertex, Direction direction, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return new FilterIterable<Edge>(this.getEdges(direction, authorizations)){

            protected boolean isIncluded(Edge edge) {
                return edge.getOtherVertexId(InMemoryVertex.this.getId()).equals(otherVertex.getId());
            }
        };
    }

    public Iterable<String> getEdgeIds(Vertex otherVertex, Direction direction, Authorizations authorizations) {
        return new EdgeToEdgeIdIterable(this.getEdges(otherVertex, direction, authorizations));
    }

    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, String label, Authorizations authorizations) {
        return this.getEdges(otherVertex, direction, label, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(final Vertex otherVertex, Direction direction, String label, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return new FilterIterable<Edge>(this.getEdges(direction, label, authorizations)){

            protected boolean isIncluded(Edge edge) {
                return edge.getOtherVertexId(InMemoryVertex.this.getId()).equals(otherVertex.getId());
            }
        };
    }

    public Iterable<String> getEdgeIds(Vertex otherVertex, Direction direction, String label, Authorizations authorizations) {
        return new EdgeToEdgeIdIterable(this.getEdges(otherVertex, direction, label, authorizations));
    }

    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, String[] labels, Authorizations authorizations) {
        return this.getEdges(otherVertex, direction, labels, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(final Vertex otherVertex, Direction direction, String[] labels, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return new FilterIterable<Edge>(this.getEdges(direction, labels, authorizations)){

            protected boolean isIncluded(Edge edge) {
                return edge.getOtherVertexId(InMemoryVertex.this.getId()).equals(otherVertex.getId());
            }
        };
    }

    public Iterable<String> getEdgeIds(Vertex otherVertex, Direction direction, String[] labels, Authorizations authorizations) {
        return new EdgeToEdgeIdIterable(this.getEdges(otherVertex, direction, labels, authorizations));
    }

    public int getEdgeCount(Direction direction, Authorizations authorizations) {
        return IterableUtils.count(this.getEdgeIds(direction, authorizations));
    }

    public Iterable<String> getEdgeLabels(Direction direction, Authorizations authorizations) {
        return IterableUtils.toSet((Iterable)new ConvertingIterable<Edge, String>(this.getEdges(direction, authorizations)){

            protected String convert(Edge o) {
                return o.getLabel();
            }
        });
    }

    public Iterable<Vertex> getVertices(Direction direction, Authorizations authorizations) {
        return this.getVertices(direction, FetchHint.ALL, authorizations);
    }

    public Iterable<Vertex> getVertices(Direction direction, EnumSet<FetchHint> fetchHints, final Authorizations authorizations) {
        return new ConvertingIterable<Edge, Vertex>(this.getEdges(direction, authorizations)){

            protected Vertex convert(Edge edge) {
                return InMemoryVertex.this.getOtherVertexFromEdge(edge, authorizations);
            }
        };
    }

    public Iterable<Vertex> getVertices(Direction direction, String label, Authorizations authorizations) {
        return this.getVertices(direction, label, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Vertex> getVertices(Direction direction, String label, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getVertices(direction, this.labelToArrayOrNull(label), authorizations);
    }

    public Iterable<Vertex> getVertices(Direction direction, String[] labels, Authorizations authorizations) {
        return this.getVertices(direction, labels, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Vertex> getVertices(Direction direction, String[] labels, EnumSet<FetchHint> fetchHints, final Authorizations authorizations) {
        return new ConvertingIterable<Edge, Vertex>(this.getEdges(direction, labels, authorizations)){

            protected Vertex convert(Edge edge) {
                return InMemoryVertex.this.getOtherVertexFromEdge(edge, authorizations);
            }
        };
    }

    public Iterable<String> getVertexIds(Direction direction, String label, Authorizations authorizations) {
        return new ConvertingIterable<Vertex, String>(this.getVertices(direction, label, authorizations)){

            protected String convert(Vertex o) {
                return o.getId();
            }
        };
    }

    public Iterable<String> getVertexIds(Direction direction, String[] labels, Authorizations authorizations) {
        return new ConvertingIterable<Vertex, String>(this.getVertices(direction, labels, authorizations)){

            protected String convert(Vertex o) {
                return o.getId();
            }
        };
    }

    public Iterable<String> getVertexIds(Direction direction, Authorizations authorizations) {
        return new ConvertingIterable<Vertex, String>(this.getVertices(direction, authorizations)){

            protected String convert(Vertex o) {
                return o.getId();
            }
        };
    }

    private Vertex getOtherVertexFromEdge(Edge edge, Authorizations authorizations) {
        if (edge.getVertexId(Direction.IN).equals(this.getId())) {
            return edge.getVertex(Direction.OUT, authorizations);
        }
        if (edge.getVertexId(Direction.OUT).equals(this.getId())) {
            return edge.getVertex(Direction.IN, authorizations);
        }
        throw new IllegalStateException("Edge does not contain vertex on either end");
    }

    public VertexQuery query(Authorizations authorizations) {
        return this.query(null, authorizations);
    }

    public VertexQuery query(String queryString, Authorizations authorizations) {
        return this.getGraph().getSearchIndex().queryVertex((Graph)this.getGraph(), (Vertex)this, queryString, authorizations);
    }

    public ExistingElementMutation<Vertex> prepareMutation() {
        return new ExistingElementMutationImpl<Vertex>((Vertex)this){

            public Vertex save(Authorizations authorizations) {
                InMemoryVertex.this.saveExistingElementMutation(this, authorizations);
                return (Vertex)this.getElement();
            }
        };
    }

    public static InMemoryVertex updateOrCreate(InMemoryGraph graph, InMemoryVertex existingVertex, InMemoryVertex newVertex, Authorizations authorizations) {
        if (existingVertex == null) {
            return newVertex;
        }
        existingVertex.updateExisting(newVertex);
        return existingVertex;
    }
}

