/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo.serializer.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.HashMap;
import org.apache.accumulo.core.data.Value;
import org.neolumin.vertexium.accumulo.EdgeInfo;
import org.neolumin.vertexium.accumulo.StreamingPropertyValueHdfsRef;
import org.neolumin.vertexium.accumulo.StreamingPropertyValueRef;
import org.neolumin.vertexium.accumulo.StreamingPropertyValueTableRef;
import org.neolumin.vertexium.accumulo.serializer.ValueSerializer;
import org.neolumin.vertexium.type.GeoPoint;

public class KryoValueSerializer
implements ValueSerializer {
    private final Kryo kryo = new Kryo();

    public KryoValueSerializer() {
        this.kryo.register(EdgeInfo.class, 1000);
        this.kryo.register(GeoPoint.class, 1001);
        this.kryo.register(HashMap.class, 1002);
        this.kryo.register(StreamingPropertyValueRef.class, 1003);
        this.kryo.register(StreamingPropertyValueTableRef.class, 1004);
        this.kryo.register(StreamingPropertyValueHdfsRef.class, 1005);
    }

    public Value objectToValue(Object value) {
        Output output = new Output(2000);
        this.kryo.writeClassAndObject(output, value);
        return new Value(output.toBytes());
    }

    public <T> T valueToObject(Value value) {
        return this.valueToObject(value.get());
    }

    public <T> T valueToObject(byte[] data) {
        Input input = new Input(data);
        return (T)this.kryo.readClassAndObject(input);
    }
}

