/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.abi;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.nervos.appchain.abi.FunctionReturnDecoder;
import org.nervos.appchain.abi.TypeEncoder;
import org.nervos.appchain.abi.TypeReference;
import org.nervos.appchain.abi.datatypes.DynamicArray;
import org.nervos.appchain.abi.datatypes.DynamicBytes;
import org.nervos.appchain.abi.datatypes.Function;
import org.nervos.appchain.abi.datatypes.NumericType;
import org.nervos.appchain.abi.datatypes.StaticArray;
import org.nervos.appchain.abi.datatypes.Type;
import org.nervos.appchain.abi.datatypes.Uint;
import org.nervos.appchain.abi.datatypes.Utf8String;
import org.nervos.appchain.abi.datatypes.generated.Bytes16;
import org.nervos.appchain.abi.datatypes.generated.Bytes32;
import org.nervos.appchain.abi.datatypes.generated.Uint256;
import org.nervos.appchain.crypto.Hash;
import org.nervos.appchain.utils.Numeric;

public class FunctionReturnDecoderTest {
    @Test
    public void testSimpleFunctionDecode() {
        Function function = new Function("test", Collections.emptyList(), Collections.singletonList(new TypeReference<Uint>(){}));
        Assert.assertThat((Object)FunctionReturnDecoder.decode((String)"0x0000000000000000000000000000000000000000000000000000000000000037", (List)function.getOutputParameters()), (Matcher)IsEqual.equalTo(Collections.singletonList(new Uint(BigInteger.valueOf(55L)))));
    }

    @Test
    public void testSimpleFunctionStringResultDecode() {
        Function function = new Function("simple", Arrays.asList(new Type[0]), Collections.singletonList(new TypeReference<Utf8String>(){}));
        List utf8Strings = FunctionReturnDecoder.decode((String)"0x0000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000000d6f6e65206d6f72652074696d6500000000000000000000000000000000000000", (List)function.getOutputParameters());
        Assert.assertThat((Object)((Type)utf8Strings.get(0)).getValue(), (Matcher)CoreMatchers.is((Object)"one more time"));
    }

    @Test
    public void testFunctionEmptyStringResultDecode() {
        Function function = new Function("test", Collections.emptyList(), Collections.singletonList(new TypeReference<Utf8String>(){}));
        List utf8Strings = FunctionReturnDecoder.decode((String)"0x00000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000000", (List)function.getOutputParameters());
        Assert.assertThat((Object)((Type)utf8Strings.get(0)).getValue(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void testMultipleResultFunctionDecode() {
        Function function = new Function("test", Collections.emptyList(), Arrays.asList(new TypeReference<Uint>(){}, new TypeReference<Uint>(){}));
        Assert.assertThat((Object)FunctionReturnDecoder.decode((String)"0x00000000000000000000000000000000000000000000000000000000000000370000000000000000000000000000000000000000000000000000000000000007", (List)function.getOutputParameters()), (Matcher)IsEqual.equalTo(Arrays.asList(new Uint(BigInteger.valueOf(55L)), new Uint(BigInteger.valueOf(7L)))));
    }

    @Test
    public void testDecodeMultipleStringValues() {
        Function function = new Function("function", Collections.emptyList(), Arrays.asList(new TypeReference<Utf8String>(){}, new TypeReference<Utf8String>(){}, new TypeReference<Utf8String>(){}, new TypeReference<Utf8String>(){}));
        Assert.assertThat((Object)FunctionReturnDecoder.decode((String)"0x000000000000000000000000000000000000000000000000000000000000008000000000000000000000000000000000000000000000000000000000000000c000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000140000000000000000000000000000000000000000000000000000000000000000464656631000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004676869310000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000046a6b6c310000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000046d6e6f3200000000000000000000000000000000000000000000000000000000", (List)function.getOutputParameters()), (Matcher)IsEqual.equalTo(Arrays.asList(new Utf8String("def1"), new Utf8String("ghi1"), new Utf8String("jkl1"), new Utf8String("mno2"))));
    }

    @Test
    public void testDecodeStaticArrayValue() {
        ArrayList<Object> outputParameters = new ArrayList<Object>(1);
        outputParameters.add(new TypeReference.StaticArrayTypeReference<StaticArray<Uint256>>(2){});
        outputParameters.add(new TypeReference<Uint256>(){});
        List decoded = FunctionReturnDecoder.decode((String)"0x00000000000000000000000000000000000000000000000000000000000000370000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000a", outputParameters);
        List<Type> expected = Arrays.asList(new StaticArray((Type[])new Uint256[]{new Uint256(BigInteger.valueOf(55L)), new Uint256(BigInteger.ONE)}), new Uint256(BigInteger.TEN));
        Assert.assertThat((Object)decoded, (Matcher)IsEqual.equalTo(expected));
    }

    @Test
    public void testVoidResultFunctionDecode() {
        Function function = new Function("test", Collections.emptyList(), Collections.emptyList());
        Assert.assertThat((Object)FunctionReturnDecoder.decode((String)"0x", (List)function.getOutputParameters()), (Matcher)CoreMatchers.is(Collections.emptyList()));
    }

    @Test
    public void testEmptyResultFunctionDecode() {
        Function function = new Function("test", Collections.emptyList(), Collections.singletonList(new TypeReference<Uint>(){}));
        Assert.assertThat((Object)FunctionReturnDecoder.decode((String)"0x", (List)function.getOutputParameters()), (Matcher)CoreMatchers.is(Collections.emptyList()));
    }

    @Test
    public void testDecodeIndexedUint256Value() {
        Uint256 value = new Uint256(BigInteger.TEN);
        String encoded = TypeEncoder.encodeNumeric((NumericType)value);
        Assert.assertThat((Object)FunctionReturnDecoder.decodeIndexedValue((String)encoded, (TypeReference)new TypeReference<Uint256>(){}), (Matcher)IsEqual.equalTo((Object)value));
    }

    @Test
    public void testDecodeIndexedStringValue() {
        Utf8String string = new Utf8String("some text");
        String encoded = TypeEncoder.encodeString((Utf8String)string);
        String hash = Hash.sha3((String)encoded);
        Assert.assertThat((Object)FunctionReturnDecoder.decodeIndexedValue((String)hash, (TypeReference)new TypeReference<Utf8String>(){}), (Matcher)IsEqual.equalTo((Object)new Bytes32(Numeric.hexStringToByteArray((String)hash))));
    }

    @Test
    public void testDecodeIndexedBytes32Value() {
        String rawInput = "0x1234567890123456789012345678901234567890123456789012345678901234";
        byte[] rawInputBytes = Numeric.hexStringToByteArray((String)rawInput);
        Assert.assertThat((Object)FunctionReturnDecoder.decodeIndexedValue((String)rawInput, (TypeReference)new TypeReference<Bytes32>(){}), (Matcher)IsEqual.equalTo((Object)new Bytes32(rawInputBytes)));
    }

    @Test
    public void testDecodeIndexedBytes16Value() {
        String rawInput = "0x1234567890123456789012345678901200000000000000000000000000000000";
        byte[] rawInputBytes = Numeric.hexStringToByteArray((String)rawInput.substring(0, 34));
        Assert.assertThat((Object)FunctionReturnDecoder.decodeIndexedValue((String)rawInput, (TypeReference)new TypeReference<Bytes16>(){}), (Matcher)IsEqual.equalTo((Object)new Bytes16(rawInputBytes)));
    }

    @Test
    public void testDecodeIndexedDynamicBytesValue() {
        DynamicBytes bytes = new DynamicBytes(new byte[]{1, 2, 3, 4, 5});
        String encoded = TypeEncoder.encodeDynamicBytes((DynamicBytes)bytes);
        String hash = Hash.sha3((String)encoded);
        Assert.assertThat((Object)FunctionReturnDecoder.decodeIndexedValue((String)hash, (TypeReference)new TypeReference<DynamicBytes>(){}), (Matcher)IsEqual.equalTo((Object)new Bytes32(Numeric.hexStringToByteArray((String)hash))));
    }

    @Test
    public void testDecodeIndexedDynamicArrayValue() {
        DynamicArray array = new DynamicArray((Type[])new Uint256[]{new Uint256(BigInteger.TEN)});
        String encoded = TypeEncoder.encodeDynamicArray((DynamicArray)array);
        String hash = Hash.sha3((String)encoded);
        Assert.assertThat((Object)FunctionReturnDecoder.decodeIndexedValue((String)hash, (TypeReference)new TypeReference<DynamicArray>(){}), (Matcher)IsEqual.equalTo((Object)new Bytes32(Numeric.hexStringToByteArray((String)hash))));
    }
}

