/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.abi;

import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import org.nervos.appchain.abi.TypeEncoder;
import org.nervos.appchain.abi.datatypes.Function;
import org.nervos.appchain.abi.datatypes.StaticArray;
import org.nervos.appchain.abi.datatypes.Type;
import org.nervos.appchain.abi.datatypes.Uint;
import org.nervos.appchain.crypto.Hash;
import org.nervos.appchain.utils.Numeric;

public class FunctionEncoder {
    private FunctionEncoder() {
    }

    public static String encode(Function function) {
        List<Type> parameters = function.getInputParameters();
        String methodSignature = FunctionEncoder.buildMethodSignature(function.getName(), parameters);
        String methodId = FunctionEncoder.buildMethodId(methodSignature);
        StringBuilder result = new StringBuilder();
        result.append(methodId);
        return FunctionEncoder.encodeParameters(parameters, result);
    }

    public static String encodeConstructor(List<Type> parameters) {
        return FunctionEncoder.encodeParameters(parameters, new StringBuilder());
    }

    private static String encodeParameters(List<Type> parameters, StringBuilder result) {
        int dynamicDataOffset = FunctionEncoder.getLength(parameters) * 32;
        StringBuilder dynamicData = new StringBuilder();
        for (Type parameter : parameters) {
            String encodedValue = TypeEncoder.encode(parameter);
            if (TypeEncoder.isDynamic(parameter)) {
                String encodedDataOffset = TypeEncoder.encodeNumeric(new Uint(BigInteger.valueOf(dynamicDataOffset)));
                result.append(encodedDataOffset);
                dynamicData.append(encodedValue);
                dynamicDataOffset += encodedValue.length() >> 1;
                continue;
            }
            result.append(encodedValue);
        }
        result.append((CharSequence)dynamicData);
        return result.toString();
    }

    private static int getLength(List<Type> parameters) {
        int count = 0;
        for (Type type : parameters) {
            if (type instanceof StaticArray) {
                count += ((StaticArray)type).getValue().size();
                continue;
            }
            ++count;
        }
        return count;
    }

    static String buildMethodSignature(String methodName, List<Type> parameters) {
        StringBuilder result = new StringBuilder();
        result.append(methodName);
        result.append("(");
        String params = parameters.stream().map(Type::getTypeAsString).collect(Collectors.joining(","));
        result.append(params);
        result.append(")");
        return result.toString();
    }

    static String buildMethodId(String methodSignature) {
        byte[] input = methodSignature.getBytes();
        byte[] hash = Hash.sha3((byte[])input);
        return Numeric.toHexString((byte[])hash).substring(0, 10);
    }
}

