/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.abi;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.nervos.appchain.abi.TypeReference;
import org.nervos.appchain.abi.Utils;
import org.nervos.appchain.abi.datatypes.Bool;
import org.nervos.appchain.abi.datatypes.DynamicArray;
import org.nervos.appchain.abi.datatypes.DynamicBytes;
import org.nervos.appchain.abi.datatypes.Fixed;
import org.nervos.appchain.abi.datatypes.Int;
import org.nervos.appchain.abi.datatypes.StaticArray;
import org.nervos.appchain.abi.datatypes.Ufixed;
import org.nervos.appchain.abi.datatypes.Uint;
import org.nervos.appchain.abi.datatypes.Utf8String;
import org.nervos.appchain.abi.datatypes.generated.Int64;
import org.nervos.appchain.abi.datatypes.generated.Uint256;
import org.nervos.appchain.abi.datatypes.generated.Uint64;

public class UtilsTest {
    @Test
    public void testGetTypeName() throws ClassNotFoundException {
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<Uint>(){}), (Matcher)CoreMatchers.is((Object)"uint256"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<Int>(){}), (Matcher)CoreMatchers.is((Object)"int256"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<Ufixed>(){}), (Matcher)CoreMatchers.is((Object)"ufixed256"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<Fixed>(){}), (Matcher)CoreMatchers.is((Object)"fixed256"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<Uint64>(){}), (Matcher)CoreMatchers.is((Object)"uint64"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<Int64>(){}), (Matcher)CoreMatchers.is((Object)"int64"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<Bool>(){}), (Matcher)CoreMatchers.is((Object)"bool"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<Utf8String>(){}), (Matcher)CoreMatchers.is((Object)"string"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<DynamicBytes>(){}), (Matcher)CoreMatchers.is((Object)"bytes"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference.StaticArrayTypeReference<StaticArray<Uint>>(5){}), (Matcher)CoreMatchers.is((Object)"uint256[5]"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<DynamicArray<Uint>>(){}), (Matcher)CoreMatchers.is((Object)"uint256[]"));
    }

    @Test
    public void testTypeMap() throws Exception {
        List<BigInteger> input = Arrays.asList(BigInteger.ZERO, BigInteger.ONE, BigInteger.TEN);
        MatcherAssert.assertThat((Object)Utils.typeMap(input, Uint256.class), (Matcher)CoreMatchers.equalTo(Arrays.asList(new Uint256(BigInteger.ZERO), new Uint256(BigInteger.ONE), new Uint256(BigInteger.TEN))));
    }

    @Test
    public void testTypeMapEmpty() {
        MatcherAssert.assertThat((Object)Utils.typeMap(new ArrayList(), Uint256.class), (Matcher)CoreMatchers.equalTo(new ArrayList()));
    }
}

