/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.abi;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.nervos.appchain.abi.TypeReference;
import org.nervos.appchain.abi.Utils;
import org.nervos.appchain.abi.datatypes.Event;
import org.nervos.appchain.abi.datatypes.Type;
import org.nervos.appchain.abi.datatypes.UnorderedEvent;
import org.nervos.appchain.crypto.Hash;
import org.nervos.appchain.utils.Numeric;

public class EventEncoder {
    private EventEncoder() {
    }

    public static String encode(Event function) {
        List indexedParameters = function.getIndexedParameters();
        List nonIndexedParameters = function.getNonIndexedParameters();
        String methodSignature = EventEncoder.buildMethodSignature(function.getName(), indexedParameters, nonIndexedParameters);
        return EventEncoder.buildEventSignature(methodSignature);
    }

    public static String encode(UnorderedEvent event) {
        List parameters = event.getParameters();
        String methodSignature = EventEncoder.buildMethodSignature(event.getName(), parameters);
        return EventEncoder.buildEventSignature(methodSignature);
    }

    static <T extends Type> String buildMethodSignature(String methodName, List<TypeReference<T>> parameters) {
        StringBuilder result = new StringBuilder();
        result.append(methodName);
        result.append("(");
        String params = parameters.stream().map(Utils::getTypeName).collect(Collectors.joining(","));
        result.append(params);
        result.append(")");
        return result.toString();
    }

    static <T extends Type> String buildMethodSignature(String methodName, List<TypeReference<T>> indexParameters, List<TypeReference<T>> nonIndexedParameters) {
        ArrayList<TypeReference<T>> parameters = new ArrayList<TypeReference<T>>(indexParameters);
        parameters.addAll(nonIndexedParameters);
        StringBuilder result = new StringBuilder();
        result.append(methodName);
        result.append("(");
        String params = parameters.stream().map(p -> Utils.getTypeName(p)).collect(Collectors.joining(","));
        result.append(params);
        result.append(")");
        return result.toString();
    }

    public static String buildEventSignature(String methodSignature) {
        byte[] input = methodSignature.getBytes();
        byte[] hash = Hash.sha3((byte[])input);
        return Numeric.toHexString((byte[])hash);
    }
}

