/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.api;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.nervos.api.CkbApi;
import org.nervos.ckb.CkbRpcApi;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.service.RpcResponse;
import org.nervos.ckb.service.RpcService;
import org.nervos.ckb.type.BannedAddress;
import org.nervos.ckb.type.BannedResultAddress;
import org.nervos.ckb.type.Block;
import org.nervos.ckb.type.BlockEconomicState;
import org.nervos.ckb.type.BlockchainInfo;
import org.nervos.ckb.type.Consensus;
import org.nervos.ckb.type.Cycles;
import org.nervos.ckb.type.Epoch;
import org.nervos.ckb.type.Header;
import org.nervos.ckb.type.NodeInfo;
import org.nervos.ckb.type.OutPoint;
import org.nervos.ckb.type.PeerNodeInfo;
import org.nervos.ckb.type.RawTxPool;
import org.nervos.ckb.type.RawTxPoolVerbose;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.SyncState;
import org.nervos.ckb.type.TransactionProof;
import org.nervos.ckb.type.TxPoolInfo;
import org.nervos.ckb.type.cell.CellWithStatus;
import org.nervos.ckb.type.param.OutputsValidator;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.type.transaction.TransactionWithStatus;
import org.nervos.indexer.CkbIndexerApi;
import org.nervos.indexer.DefaultIndexerApi;
import org.nervos.indexer.model.SearchKey;
import org.nervos.indexer.model.resp.CellCapacityResponse;
import org.nervos.indexer.model.resp.CellsResponse;
import org.nervos.indexer.model.resp.TipResponse;
import org.nervos.indexer.model.resp.TransactionResponse;
import org.nervos.mercury.DefaultMercuryApi;
import org.nervos.mercury.MercuryApi;
import org.nervos.mercury.model.common.PaginationResponse;
import org.nervos.mercury.model.req.payload.AdjustAccountPayload;
import org.nervos.mercury.model.req.payload.DaoClaimPayload;
import org.nervos.mercury.model.req.payload.DaoDepositPayload;
import org.nervos.mercury.model.req.payload.DaoWithdrawPayload;
import org.nervos.mercury.model.req.payload.GetBalancePayload;
import org.nervos.mercury.model.req.payload.GetBlockInfoPayload;
import org.nervos.mercury.model.req.payload.GetSpentTransactionPayload;
import org.nervos.mercury.model.req.payload.QueryTransactionsPayload;
import org.nervos.mercury.model.req.payload.SimpleTransferPayload;
import org.nervos.mercury.model.req.payload.SudtIssuePayload;
import org.nervos.mercury.model.req.payload.TransferPayload;
import org.nervos.mercury.model.resp.BlockInfoResponse;
import org.nervos.mercury.model.resp.GetBalanceResponse;
import org.nervos.mercury.model.resp.GetTransactionInfoResponse;
import org.nervos.mercury.model.resp.TransactionCompletionResponse;
import org.nervos.mercury.model.resp.TransactionInfoResponse;
import org.nervos.mercury.model.resp.TransactionWithRichStatus;
import org.nervos.mercury.model.resp.TxView;
import org.nervos.mercury.model.resp.info.DBInfo;
import org.nervos.mercury.model.resp.info.MercuryInfo;

public class DefaultCkbApi
implements CkbApi {
    private CkbRpcApi ckbApi;
    private MercuryApi mercuryApi;
    private CkbIndexerApi ckbIndexerApi;

    public DefaultCkbApi(String ckbUrl, String mercuryUrl, String indexerUrl, boolean isDebug) {
        if (Objects.nonNull(ckbUrl)) {
            this.ckbApi = new Api(new RpcService(ckbUrl, isDebug));
        }
        if (Objects.nonNull(indexerUrl)) {
            this.ckbIndexerApi = new DefaultIndexerApi(new RpcService(indexerUrl, isDebug));
        }
        if (Objects.nonNull(mercuryUrl)) {
            this.mercuryApi = new DefaultMercuryApi(new RpcService(mercuryUrl, isDebug));
        }
    }

    public TipResponse getTip() throws IOException {
        if (this.mercuryApi != null) {
            return this.mercuryApi.getTip();
        }
        if (this.ckbIndexerApi != null) {
            return this.ckbIndexerApi.getTip();
        }
        return null;
    }

    public CellsResponse getCells(SearchKey searchKey, String order, String limit, String afterCursor) throws IOException {
        if (this.mercuryApi != null) {
            return this.mercuryApi.getCells(searchKey, order, limit, afterCursor);
        }
        if (this.ckbIndexerApi != null) {
            return this.ckbIndexerApi.getCells(searchKey, order, limit, afterCursor);
        }
        return null;
    }

    public TransactionResponse getTransactions(SearchKey searchKey, String order, String limit, String afterCursor) throws IOException {
        if (this.mercuryApi != null) {
            return this.mercuryApi.getTransactions(searchKey, order, limit, afterCursor);
        }
        if (this.ckbIndexerApi != null) {
            return this.ckbIndexerApi.getTransactions(searchKey, order, limit, afterCursor);
        }
        return null;
    }

    public CellCapacityResponse getCellsCapacity(SearchKey searchKey) throws IOException {
        if (this.mercuryApi != null) {
            return this.mercuryApi.getCellsCapacity(searchKey);
        }
        if (this.ckbIndexerApi != null) {
            return this.ckbIndexerApi.getCellsCapacity(searchKey);
        }
        return null;
    }

    public Block getBlock(String blockHash) throws IOException {
        return this.ckbApi.getBlock(blockHash);
    }

    public Block getBlockByNumber(String blockNumber) throws IOException {
        return this.ckbApi.getBlockByNumber(blockNumber);
    }

    public TransactionWithStatus getTransaction(String transactionHash) throws IOException {
        return this.ckbApi.getTransaction(transactionHash);
    }

    public String getBlockHash(String blockNumber) throws IOException {
        return this.ckbApi.getBlockHash(blockNumber);
    }

    public BlockEconomicState getBlockEconomicState(String blockHash) throws IOException {
        return this.ckbApi.getBlockEconomicState(blockHash);
    }

    public Header getTipHeader() throws IOException {
        return this.ckbApi.getTipHeader();
    }

    public CellWithStatus getLiveCell(OutPoint outPoint, boolean withData) throws IOException {
        return this.ckbApi.getLiveCell(outPoint, withData);
    }

    public BigInteger getTipBlockNumber() throws IOException {
        return this.ckbApi.getTipBlockNumber();
    }

    public Epoch getCurrentEpoch() throws IOException {
        return this.ckbApi.getCurrentEpoch();
    }

    public Epoch getEpochByNumber(String epochNumber) throws IOException {
        return this.ckbApi.getEpochByNumber(epochNumber);
    }

    public Header getHeader(String blockHash) throws IOException {
        return this.ckbApi.getHeader(blockHash);
    }

    public Header getHeaderByNumber(String blockNumber) throws IOException {
        return this.ckbApi.getHeaderByNumber(blockNumber);
    }

    public TransactionProof getTransactionProof(List<String> txHashes) throws IOException {
        return this.ckbApi.getTransactionProof(txHashes);
    }

    public TransactionProof getTransactionProof(List<String> txHashes, String blockHash) throws IOException {
        return this.ckbApi.getTransactionProof(txHashes, blockHash);
    }

    public List<String> verifyTransactionProof(TransactionProof transactionProof) throws IOException {
        return this.ckbApi.verifyTransactionProof(transactionProof);
    }

    public Block getForkBlock(String blockHash) throws IOException {
        return this.ckbApi.getForkBlock(blockHash);
    }

    public Consensus getConsensus() throws IOException {
        return this.ckbApi.getConsensus();
    }

    public String getBlockMedianTime(String blockHash) throws IOException {
        return this.ckbApi.getBlockMedianTime(blockHash);
    }

    public BlockchainInfo getBlockchainInfo() throws IOException {
        return this.ckbApi.getBlockchainInfo();
    }

    public TxPoolInfo txPoolInfo() throws IOException {
        return this.ckbApi.txPoolInfo();
    }

    public String clearTxPool() throws IOException {
        return this.ckbApi.clearTxPool();
    }

    public RawTxPool getRawTxPool() throws IOException {
        return this.ckbApi.getRawTxPool();
    }

    public RawTxPoolVerbose getRawTxPoolVerbose() throws IOException {
        return this.ckbApi.getRawTxPoolVerbose();
    }

    public String sendTransaction(Transaction transaction) throws IOException {
        return this.ckbApi.sendTransaction(transaction);
    }

    public String sendTransaction(Transaction transaction, OutputsValidator outputsValidator) throws IOException {
        return this.ckbApi.sendTransaction(transaction, outputsValidator);
    }

    public NodeInfo localNodeInfo() throws IOException {
        return this.ckbApi.localNodeInfo();
    }

    public List<PeerNodeInfo> getPeers() throws IOException {
        return this.ckbApi.getPeers();
    }

    public SyncState syncState() throws IOException {
        return this.ckbApi.syncState();
    }

    public String setNetworkActive(Boolean state) throws IOException {
        return this.ckbApi.setNetworkActive(state);
    }

    public String addNode(String peerId, String address) throws IOException {
        return this.ckbApi.addNode(peerId, address);
    }

    public String removeNode(String peerId) throws IOException {
        return this.ckbApi.removeNode(peerId);
    }

    public String setBan(BannedAddress bannedAddress) throws IOException {
        return this.ckbApi.setBan(bannedAddress);
    }

    public List<BannedResultAddress> getBannedAddresses() throws IOException {
        return this.ckbApi.getBannedAddresses();
    }

    public String clearBannedAddresses() throws IOException {
        return this.ckbApi.clearBannedAddresses();
    }

    public String pingPeers() throws IOException {
        return this.ckbApi.pingPeers();
    }

    public Cycles dryRunTransaction(Transaction transaction) throws IOException {
        return this.ckbApi.dryRunTransaction(transaction);
    }

    @Deprecated
    public String computeTransactionHash(Transaction transaction) throws IOException {
        return this.ckbApi.computeTransactionHash(transaction);
    }

    @Deprecated
    public String computeScriptHash(Script script) throws IOException {
        return this.ckbApi.computeScriptHash(script);
    }

    public String calculateDaoMaximumWithdraw(OutPoint outPoint, String withdrawBlockHash) throws IOException {
        return this.ckbApi.calculateDaoMaximumWithdraw(outPoint, withdrawBlockHash);
    }

    public List<RpcResponse> batchRPC(List<List> requests) throws IOException {
        return this.ckbApi.batchRPC(requests);
    }

    public GetBalanceResponse getBalance(GetBalancePayload payload) throws IOException {
        return this.mercuryApi.getBalance(payload);
    }

    public TransactionCompletionResponse buildTransferTransaction(TransferPayload payload) throws IOException {
        return this.mercuryApi.buildTransferTransaction(payload);
    }

    public TransactionCompletionResponse buildAdjustAccountTransaction(AdjustAccountPayload payload) throws IOException {
        return this.mercuryApi.buildAdjustAccountTransaction(payload);
    }

    public TransactionCompletionResponse buildSimpleTransferTransaction(SimpleTransferPayload payload) throws IOException {
        return this.mercuryApi.buildSimpleTransferTransaction(payload);
    }

    public GetTransactionInfoResponse getTransactionInfo(String txHash) throws IOException {
        return this.mercuryApi.getTransactionInfo(txHash);
    }

    public BlockInfoResponse getBlockInfo(GetBlockInfoPayload payload) throws IOException {
        return this.mercuryApi.getBlockInfo(payload);
    }

    public List<String> registerAddresses(List<String> normalAddresses) throws IOException {
        return this.mercuryApi.registerAddresses(normalAddresses);
    }

    public PaginationResponse<TxView<TransactionWithRichStatus>> queryTransactionsWithTransactionView(QueryTransactionsPayload payload) throws IOException {
        return this.mercuryApi.queryTransactionsWithTransactionView(payload);
    }

    public PaginationResponse<TxView<TransactionInfoResponse>> queryTransactionsWithTransactionInfo(QueryTransactionsPayload payload) throws IOException {
        return this.mercuryApi.queryTransactionsWithTransactionInfo(payload);
    }

    public DBInfo getDbInfo() throws IOException {
        return this.mercuryApi.getDbInfo();
    }

    public MercuryInfo getMercuryInfo() throws IOException {
        return this.mercuryApi.getMercuryInfo();
    }

    public TxView<TransactionWithRichStatus> getSpentTransactionWithTransactionView(GetSpentTransactionPayload payload) throws IOException {
        return this.mercuryApi.getSpentTransactionWithTransactionView(payload);
    }

    public TxView<TransactionInfoResponse> getSpentTransactionWithTransactionInfo(GetSpentTransactionPayload payload) throws IOException {
        return this.mercuryApi.getSpentTransactionWithTransactionInfo(payload);
    }

    public TransactionCompletionResponse buildDaoDepositTransaction(DaoDepositPayload payload) throws IOException {
        return this.mercuryApi.buildDaoDepositTransaction(payload);
    }

    public TransactionCompletionResponse buildDaoWithdrawTransaction(DaoWithdrawPayload payload) throws IOException {
        return this.mercuryApi.buildDaoWithdrawTransaction(payload);
    }

    public TransactionCompletionResponse buildDaoClaimTransaction(DaoClaimPayload payload) throws IOException {
        return this.mercuryApi.buildDaoClaimTransaction(payload);
    }

    public TransactionCompletionResponse buildSudtIssueTransaction(SudtIssuePayload payload) throws IOException {
        return this.mercuryApi.buildSudtIssueTransaction(payload);
    }
}

