/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.api.mercury;

import com.google.gson.Gson;
import constant.ApiFactory;
import java.io.IOException;
import java.math.BigInteger;
import org.junit.jupiter.api.Test;
import org.nervos.mercury.GsonFactory;
import org.nervos.mercury.model.GetBlockInfoPayloadBuilder;
import org.nervos.mercury.model.resp.BlockInfoResponse;

public class BlockInfoTest {
    Gson g = GsonFactory.newGson();

    @Test
    void testGetBlockInfoWithBlockNumber() {
        try {
            GetBlockInfoPayloadBuilder builder = new GetBlockInfoPayloadBuilder();
            builder.blockNumber(new BigInteger("2172093"));
            System.out.println(this.g.toJson((Object)builder.build()));
            BlockInfoResponse blockInfo = ApiFactory.getApi().getBlockInfo(builder.build());
            System.out.println(this.g.toJson((Object)blockInfo));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testGetBlockInfoWithBlockHash() {
        try {
            GetBlockInfoPayloadBuilder builder = new GetBlockInfoPayloadBuilder();
            builder.blockHash("0xee8adba356105149cb9dc1cb0d09430a6bd01182868787ace587961c0d64e742");
            System.out.println(this.g.toJson((Object)builder.build()));
            BlockInfoResponse blockInfo = ApiFactory.getApi().getBlockInfo(builder.build());
            System.out.println(this.g.toJson((Object)blockInfo));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testGetBlockInfoWithBlockHashAndBlockNumber() {
        try {
            GetBlockInfoPayloadBuilder builder = new GetBlockInfoPayloadBuilder();
            builder.blockNumber(new BigInteger("2172093"));
            builder.blockHash("0xee8adba356105149cb9dc1cb0d09430a6bd01182868787ace587961c0d64e742");
            System.out.println(this.g.toJson((Object)builder.build()));
            BlockInfoResponse blockInfo = ApiFactory.getApi().getBlockInfo(builder.build());
            System.out.println(this.g.toJson((Object)blockInfo));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testTipBlockInfo() {
        try {
            GetBlockInfoPayloadBuilder builder = new GetBlockInfoPayloadBuilder();
            System.out.println(this.g.toJson((Object)builder.build()));
            BlockInfoResponse blockInfo = ApiFactory.getApi().getBlockInfo(builder.build());
            System.out.println(this.g.toJson((Object)blockInfo));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testBlockHashAndBlockNumberDoNotMatch() {
        try {
            GetBlockInfoPayloadBuilder builder = new GetBlockInfoPayloadBuilder();
            builder.blockNumber(new BigInteger("2172092"));
            builder.blockHash("0xee8adba356105149cb9dc1cb0d09430a6bd01182868787ace587961c0d64e742");
            System.out.println(this.g.toJson((Object)builder.build()));
            ApiFactory.getApi().getBlockInfo(builder.build());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    void testCannotFind() {
        try {
            GetBlockInfoPayloadBuilder builder = new GetBlockInfoPayloadBuilder();
            builder.blockHash("0xee8adba356105149cb9dc1cb0d09430a6bd01182868787ace587961c0d64e741");
            System.out.println(this.g.toJson((Object)builder.build()));
            ApiFactory.getApi().getBlockInfo(builder.build());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    void testWrongHeight() {
        try {
            GetBlockInfoPayloadBuilder builder = new GetBlockInfoPayloadBuilder();
            builder.blockNumber(new BigInteger("217209233"));
            System.out.println(this.g.toJson((Object)builder.build()));
            ApiFactory.getApi().getBlockInfo(builder.build());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

