/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.api.mercury;

import com.google.gson.Gson;
import constant.AddressWithKeyHolder;
import constant.ApiFactory;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.AmountUtils;
import org.nervos.ckb.utils.address.AddressTools;
import org.nervos.mercury.GsonFactory;
import org.nervos.mercury.model.TransferPayloadBuilder;
import org.nervos.mercury.model.common.AssetInfo;
import org.nervos.mercury.model.req.From;
import org.nervos.mercury.model.req.Mode;
import org.nervos.mercury.model.req.Source;
import org.nervos.mercury.model.req.To;
import org.nervos.mercury.model.req.ToInfo;
import org.nervos.mercury.model.req.item.ItemFactory;
import org.nervos.mercury.model.resp.TransactionCompletionResponse;
import utils.SignUtils;

public class ModeTest {
    Gson g = GsonFactory.newGson();

    @Test
    void transferCompletionCkbWithFree() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.assetInfo(AssetInfo.newCkbAsset());
        builder.from(From.newFrom(Arrays.asList(ItemFactory.newAddressItem((String)AddressWithKeyHolder.testAddress0())), (Source)Source.Free));
        builder.to(To.newTo(Arrays.asList(new ToInfo(AddressWithKeyHolder.testAddress4(), AmountUtils.ckbToShannon((long)100L))), (Mode)Mode.HoldByFrom));
        System.out.println(this.g.toJson((Object)builder.build()));
        try {
            TransactionCompletionResponse s = ApiFactory.getApi().buildTransferTransaction(builder.build());
            System.out.println(this.g.toJson((Object)s));
            Transaction tx = this.sign(s);
            String result = ApiFactory.getApi().sendTransaction(tx);
            System.out.println(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void transferCompletionSudtWithFree() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.assetInfo(AssetInfo.newUdtAsset((String)"0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd"));
        builder.from(From.newFrom(Arrays.asList(ItemFactory.newIdentityItemByAddress((String)AddressWithKeyHolder.testAddress1())), (Source)Source.Free));
        builder.to(To.newTo(Arrays.asList(new ToInfo(AddressWithKeyHolder.testAddress2(), new BigInteger("100"))), (Mode)Mode.HoldByFrom));
        try {
            TransactionCompletionResponse s = ApiFactory.getApi().buildTransferTransaction(builder.build());
            System.out.println(this.g.toJson((Object)s));
            Transaction tx = this.sign(s);
            String result = ApiFactory.getApi().sendTransaction(tx);
            System.out.println(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void transferCompletionCkbWithClaimable() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.assetInfo(AssetInfo.newCkbAsset());
        builder.from(From.newFrom(Arrays.asList(ItemFactory.newIdentityItemByAddress((String)AddressWithKeyHolder.testAddress1())), (Source)Source.Claimable));
        builder.to(To.newTo(Arrays.asList(new ToInfo(AddressWithKeyHolder.testAddress2(), AmountUtils.ckbToShannon((long)100L))), (Mode)Mode.HoldByFrom));
        try {
            TransactionCompletionResponse transactionCompletionResponse = ApiFactory.getApi().buildTransferTransaction(builder.build());
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"The transaction does not support ckb", (Object)e.getMessage());
        }
    }

    @Test
    void transferCompletionSudtWithClaimable() {
    }

    @Test
    void transferCompletionSudtWithHoldByTo() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.assetInfo(AssetInfo.newCkbAsset());
        builder.assetInfo(AssetInfo.newUdtAsset((String)"0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd"));
        builder.from(From.newFrom(Arrays.asList(ItemFactory.newIdentityItemByAddress((String)AddressWithKeyHolder.testAddress1())), (Source)Source.Free));
        builder.to(To.newTo(Arrays.asList(new ToInfo(AddressTools.generateAcpAddress((String)AddressWithKeyHolder.testAddress4()), new BigInteger("100"))), (Mode)Mode.HoldByTo));
        System.out.println(this.g.toJson((Object)builder.build()));
        try {
            TransactionCompletionResponse s = ApiFactory.getApi().buildTransferTransaction(builder.build());
            Transaction tx = this.sign(s);
            System.out.println(this.g.toJson((Object)s.txView));
            String result = ApiFactory.getApi().sendTransaction(tx);
            System.out.println(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Transaction sign(TransactionCompletionResponse s) throws IOException {
        Transaction tx = SignUtils.sign(s);
        return tx;
    }
}

