/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nervos.api.DefaultCkbApi;
import org.nervos.ckb.CkbRpcApi;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.type.Header;
import org.nervos.ckb.type.Script;
import org.nervos.indexer.CkbIndexerApi;
import org.nervos.indexer.DefaultIndexerApi;
import org.nervos.indexer.model.ScriptType;
import org.nervos.indexer.model.SearchKeyBuilder;
import org.nervos.indexer.model.resp.CellCapacityResponse;
import org.nervos.mercury.DefaultMercuryApi;
import org.nervos.mercury.MercuryApi;
import org.nervos.mercury.model.GetBalancePayloadBuilder;
import org.nervos.mercury.model.req.KeyAddress;
import org.nervos.mercury.model.req.NormalAddress;
import org.nervos.mercury.model.req.QueryAddress;
import org.nervos.mercury.model.resp.GetBalanceResponse;

public class CkbApiTest {
    private String rpcAddress = "http://127.0.0.1:8116";
    Gson g = new GsonBuilder().registerTypeAdapter(QueryAddress.class, (Object)new KeyAddress("")).registerTypeAdapter(QueryAddress.class, (Object)new NormalAddress("")).create();

    @Test
    void testCkbIndexerApi() {
        DefaultIndexerApi api = new DefaultIndexerApi(this.rpcAddress, false);
        this.indexerApi((CkbIndexerApi)api);
    }

    @Test
    void testCkbApi() {
        Api api = new Api(this.rpcAddress, false);
        this.ckbApi((CkbRpcApi)api);
    }

    @Test
    void testMercuryApi() {
        DefaultMercuryApi api = new DefaultMercuryApi(this.rpcAddress, false);
        this.mercuryApi((MercuryApi)api);
    }

    @Test
    void testAll() {
        DefaultCkbApi api = new DefaultCkbApi(this.rpcAddress, false);
        this.ckbApi((CkbRpcApi)api);
        this.indexerApi((CkbIndexerApi)api);
        this.mercuryApi((MercuryApi)api);
    }

    private void indexerApi(CkbIndexerApi api) {
        SearchKeyBuilder key = new SearchKeyBuilder();
        key.script(new Script("0x9bd7e06f3ecf4be0f2fcd2188b23f1b9fcc88e5d4b65a8637b17723bbda3cce8", "0x0c24d18f16e3c43272695e5db006a22cb9ddde51", "type"));
        key.scriptType(ScriptType.lock);
        System.out.println(new Gson().toJson((Object)key.build()));
        try {
            CellCapacityResponse capacity = api.getCellsCapacity(key.build());
            System.out.println(new Gson().toJson((Object)capacity));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void ckbApi(CkbRpcApi api) {
        try {
            Header tipHeader = api.getTipHeader();
            System.out.println(new Gson().toJson((Object)tipHeader));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void mercuryApi(MercuryApi api) {
        try {
            GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
            builder.address("ckt1qyq28wze3cw48ek9az0g4jmtfs6d8td38u4s6hp2s0");
            System.out.println(this.g.toJson((Object)builder.build()));
            GetBalanceResponse balance = api.getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

