/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.api;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.nervos.api.CkbApi;
import org.nervos.ckb.CkbRpcApi;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.service.RpcResponse;
import org.nervos.ckb.service.RpcService;
import org.nervos.ckb.type.BannedAddress;
import org.nervos.ckb.type.BannedResultAddress;
import org.nervos.ckb.type.Block;
import org.nervos.ckb.type.BlockEconomicState;
import org.nervos.ckb.type.BlockchainInfo;
import org.nervos.ckb.type.Consensus;
import org.nervos.ckb.type.Cycles;
import org.nervos.ckb.type.Epoch;
import org.nervos.ckb.type.Header;
import org.nervos.ckb.type.NodeInfo;
import org.nervos.ckb.type.OutPoint;
import org.nervos.ckb.type.PeerNodeInfo;
import org.nervos.ckb.type.RawTxPool;
import org.nervos.ckb.type.RawTxPoolVerbose;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.SyncState;
import org.nervos.ckb.type.TransactionProof;
import org.nervos.ckb.type.TxPoolInfo;
import org.nervos.ckb.type.cell.CellWithStatus;
import org.nervos.ckb.type.param.OutputsValidator;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.type.transaction.TransactionWithStatus;
import org.nervos.indexer.CkbIndexerApi;
import org.nervos.indexer.DefaultIndexerApi;
import org.nervos.indexer.model.SearchKey;
import org.nervos.indexer.model.resp.CellCapacityResponse;
import org.nervos.indexer.model.resp.CellsResponse;
import org.nervos.indexer.model.resp.TipResponse;
import org.nervos.indexer.model.resp.TransactionResponse;
import org.nervos.mercury.DefaultMercuryApi;
import org.nervos.mercury.MercuryApi;
import org.nervos.mercury.model.req.AdjustAccountPayload;
import org.nervos.mercury.model.req.CollectAssetPayload;
import org.nervos.mercury.model.req.GetBalancePayload;
import org.nervos.mercury.model.req.GetBlockInfoPayload;
import org.nervos.mercury.model.req.QueryTransactionsPayload;
import org.nervos.mercury.model.req.SmartTransferPayload;
import org.nervos.mercury.model.req.TransferPayload;
import org.nervos.mercury.model.resp.BlockInfoResponse;
import org.nervos.mercury.model.resp.GetBalanceResponse;
import org.nervos.mercury.model.resp.QueryTransactionsResponse;
import org.nervos.mercury.model.resp.TransactionCompletionResponse;
import org.nervos.mercury.model.resp.TransactionInfoWithStatusResponse;

public class DefaultCkbApi
implements CkbApi {
    private CkbRpcApi ckbApi;
    private MercuryApi mercuryApi;
    private CkbIndexerApi ckbIndexerApi;

    public DefaultCkbApi(String mercuryUrl, boolean isDebug) {
        RpcService rpcService = new RpcService(mercuryUrl, isDebug);
        this.ckbApi = new Api(rpcService);
        this.ckbIndexerApi = new DefaultIndexerApi(rpcService);
        this.mercuryApi = new DefaultMercuryApi(rpcService);
    }

    public TipResponse getTip() throws IOException {
        return this.ckbIndexerApi.getTip();
    }

    public CellsResponse getCells(SearchKey searchKey, String order, String limit, String afterCursor) throws IOException {
        return this.ckbIndexerApi.getCells(searchKey, order, limit, afterCursor);
    }

    public TransactionResponse getTransactions(SearchKey searchKey, String order, String limit, String afterCursor) throws IOException {
        return this.ckbIndexerApi.getTransactions(searchKey, order, limit, afterCursor);
    }

    public CellCapacityResponse getCellsCapacity(SearchKey searchKey) throws IOException {
        return this.ckbIndexerApi.getCellsCapacity(searchKey);
    }

    public Block getBlock(String blockHash) throws IOException {
        return this.ckbApi.getBlock(blockHash);
    }

    public Block getBlockByNumber(String blockNumber) throws IOException {
        return this.ckbApi.getBlockByNumber(blockNumber);
    }

    public TransactionWithStatus getTransaction(String transactionHash) throws IOException {
        return this.ckbApi.getTransaction(transactionHash);
    }

    public String getBlockHash(String blockNumber) throws IOException {
        return this.ckbApi.getBlockHash(blockNumber);
    }

    public BlockEconomicState getBlockEconomicState(String blockHash) throws IOException {
        return this.ckbApi.getBlockEconomicState(blockHash);
    }

    public Header getTipHeader() throws IOException {
        return this.ckbApi.getTipHeader();
    }

    public CellWithStatus getLiveCell(OutPoint outPoint, boolean withData) throws IOException {
        return this.ckbApi.getLiveCell(outPoint, withData);
    }

    public BigInteger getTipBlockNumber() throws IOException {
        return this.ckbApi.getTipBlockNumber();
    }

    public Epoch getCurrentEpoch() throws IOException {
        return this.ckbApi.getCurrentEpoch();
    }

    public Epoch getEpochByNumber(String epochNumber) throws IOException {
        return this.ckbApi.getEpochByNumber(epochNumber);
    }

    public Header getHeader(String blockHash) throws IOException {
        return this.ckbApi.getHeader(blockHash);
    }

    public Header getHeaderByNumber(String blockNumber) throws IOException {
        return this.ckbApi.getHeaderByNumber(blockNumber);
    }

    public TransactionProof getTransactionProof(List<String> txHashes) throws IOException {
        return this.ckbApi.getTransactionProof(txHashes);
    }

    public TransactionProof getTransactionProof(List<String> txHashes, String blockHash) throws IOException {
        return this.ckbApi.getTransactionProof(txHashes, blockHash);
    }

    public List<String> verifyTransactionProof(TransactionProof transactionProof) throws IOException {
        return this.ckbApi.verifyTransactionProof(transactionProof);
    }

    public Block getForkBlock(String blockHash) throws IOException {
        return this.ckbApi.getForkBlock(blockHash);
    }

    public Consensus getConsensus() throws IOException {
        return this.ckbApi.getConsensus();
    }

    public String getBlockMedianTime(String blockHash) throws IOException {
        return this.ckbApi.getBlockMedianTime(blockHash);
    }

    public BlockchainInfo getBlockchainInfo() throws IOException {
        return this.ckbApi.getBlockchainInfo();
    }

    public TxPoolInfo txPoolInfo() throws IOException {
        return this.ckbApi.txPoolInfo();
    }

    public String clearTxPool() throws IOException {
        return this.ckbApi.clearTxPool();
    }

    public RawTxPool getRawTxPool() throws IOException {
        return this.ckbApi.getRawTxPool();
    }

    public RawTxPoolVerbose getRawTxPoolVerbose() throws IOException {
        return this.ckbApi.getRawTxPoolVerbose();
    }

    public String sendTransaction(Transaction transaction) throws IOException {
        return this.ckbApi.sendTransaction(transaction);
    }

    public String sendTransaction(Transaction transaction, OutputsValidator outputsValidator) throws IOException {
        return this.ckbApi.sendTransaction(transaction, outputsValidator);
    }

    public NodeInfo localNodeInfo() throws IOException {
        return this.ckbApi.localNodeInfo();
    }

    public List<PeerNodeInfo> getPeers() throws IOException {
        return this.ckbApi.getPeers();
    }

    public SyncState syncState() throws IOException {
        return this.ckbApi.syncState();
    }

    public String setNetworkActive(Boolean state) throws IOException {
        return this.ckbApi.setNetworkActive(state);
    }

    public String addNode(String peerId, String address) throws IOException {
        return this.ckbApi.addNode(peerId, address);
    }

    public String removeNode(String peerId) throws IOException {
        return this.ckbApi.removeNode(peerId);
    }

    public String setBan(BannedAddress bannedAddress) throws IOException {
        return this.ckbApi.setBan(bannedAddress);
    }

    public List<BannedResultAddress> getBannedAddresses() throws IOException {
        return this.ckbApi.getBannedAddresses();
    }

    public String clearBannedAddresses() throws IOException {
        return this.ckbApi.clearBannedAddresses();
    }

    public String pingPeers() throws IOException {
        return this.ckbApi.pingPeers();
    }

    public Cycles dryRunTransaction(Transaction transaction) throws IOException {
        return this.ckbApi.dryRunTransaction(transaction);
    }

    @Deprecated
    public String computeTransactionHash(Transaction transaction) throws IOException {
        return this.ckbApi.computeTransactionHash(transaction);
    }

    @Deprecated
    public String computeScriptHash(Script script) throws IOException {
        return this.ckbApi.computeScriptHash(script);
    }

    public String calculateDaoMaximumWithdraw(OutPoint outPoint, String withdrawBlockHash) throws IOException {
        return this.ckbApi.calculateDaoMaximumWithdraw(outPoint, withdrawBlockHash);
    }

    public List<RpcResponse> batchRPC(List<List> requests) throws IOException {
        return this.ckbApi.batchRPC(requests);
    }

    public GetBalanceResponse getBalance(GetBalancePayload payload) throws IOException {
        return this.mercuryApi.getBalance(payload);
    }

    public TransactionCompletionResponse buildTransferTransaction(TransferPayload payload) throws IOException {
        return this.mercuryApi.buildTransferTransaction(payload);
    }

    public TransactionCompletionResponse buildAdjustAccountTransaction(AdjustAccountPayload payload) throws IOException {
        return this.mercuryApi.buildAdjustAccountTransaction(payload);
    }

    public TransactionCompletionResponse buildSmartTransferTransaction(SmartTransferPayload payload) throws IOException {
        return this.mercuryApi.buildSmartTransferTransaction(payload);
    }

    public TransactionInfoWithStatusResponse getTransactionInfo(String txHash) throws IOException {
        return this.mercuryApi.getTransactionInfo(txHash);
    }

    public BlockInfoResponse getBlockInfo(GetBlockInfoPayload payload) throws IOException {
        return this.mercuryApi.getBlockInfo(payload);
    }

    public List<String> registerAddresses(List<String> normalAddresses) throws IOException {
        return this.mercuryApi.registerAddresses(normalAddresses);
    }

    public TransactionCompletionResponse buildAssetCollectionTransaction(CollectAssetPayload payload) throws IOException {
        return this.mercuryApi.buildAssetCollectionTransaction(payload);
    }

    public QueryTransactionsResponse queryTransactions(QueryTransactionsPayload payload) throws IOException {
        return this.mercuryApi.queryTransactions(payload);
    }

    public Integer getAccountNumber(String address) throws IOException {
        return this.mercuryApi.getAccountNumber(address);
    }
}

