/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.api.mercury;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import constant.AddressWithKeyHolder;
import constant.ApiFactory;
import java.io.IOException;
import java.math.BigInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.type.OutPoint;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.utils.address.AddressTools;
import org.nervos.indexer.model.ScriptType;
import org.nervos.indexer.model.SearchKeyBuilder;
import org.nervos.indexer.model.resp.CellResponse;
import org.nervos.indexer.model.resp.CellsResponse;
import org.nervos.indexer.model.resp.OutPointResponse;
import org.nervos.mercury.model.GetBalancePayloadBuilder;
import org.nervos.mercury.model.common.AssetInfo;
import org.nervos.mercury.model.req.item.Item;
import org.nervos.mercury.model.resp.GetBalanceResponse;

public class BalanceTest {
    Gson g = new GsonBuilder().create();

    @Test
    void getCkbBalance() {
        try {
            GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
            builder.item(Item.newIdentityItemByCkb((String)AddressWithKeyHolder.testPubKey4()));
            builder.addAssetInfo(AssetInfo.newCkbAsset());
            System.out.println(this.g.toJson((Object)builder.build()));
            GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void getSudtBalance() {
        GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
        builder.item(Item.newIdentityItemByCkb((String)AddressWithKeyHolder.testPubKey4()));
        builder.addAssetInfo(AssetInfo.newUdtAsset((String)"0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd"));
        System.out.println(this.g.toJson((Object)builder.build()));
        try {
            GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void getAllBalance() {
        GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
        builder.item(Item.newIdentityItemByCkb((String)AddressWithKeyHolder.testPubKey4()));
        System.out.println(this.g.toJson((Object)builder.build()));
        try {
            GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
            System.out.println(balance.balances.size());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void getBalanceByAddress() {
        try {
            GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
            builder.item(Item.newAddressItem((String)AddressWithKeyHolder.testAddress4()));
            builder.addAssetInfo(AssetInfo.newCkbAsset());
            System.out.println(this.g.toJson((Object)builder.build()));
            GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void getBalanceByIdentity() {
        try {
            GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
            builder.item(Item.newIdentityItemByCkb((String)AddressWithKeyHolder.testPubKey4()));
            builder.addAssetInfo(AssetInfo.newUdtAsset((String)"0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd"));
            System.out.println(this.g.toJson((Object)builder.build()));
            GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void getBalanceByRecordByScriptByChequeCellSender() {
        try {
            Script script = AddressTools.parse((String)AddressWithKeyHolder.testAddress1()).script;
            OutPointResponse outPoint = new OutPointResponse();
            outPoint.txHash = "0xecfea4bdf6bf8290d8f8186ed9f4da9b0f8fbba217600b47632f5a72ff677d4d";
            outPoint.index = "0x0";
            GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
            builder.item(Item.newRecordItemByScript((OutPoint)new OutPoint(outPoint.txHash, outPoint.index), (Script)script));
            builder.addAssetInfo(AssetInfo.newCkbAsset());
            System.out.println(this.g.toJson((Object)builder.build()));
            GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void getBalanceByRecordByScriptChequeCellReceiver() {
        try {
            Script script = AddressTools.parse((String)AddressWithKeyHolder.testAddress2()).script;
            OutPointResponse outPoint = new OutPointResponse();
            outPoint.txHash = "0xecfea4bdf6bf8290d8f8186ed9f4da9b0f8fbba217600b47632f5a72ff677d4d";
            outPoint.index = "0x0";
            GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
            builder.item(Item.newRecordItemByScript((OutPoint)new OutPoint(outPoint.txHash, outPoint.index), (Script)script));
            builder.addAssetInfo(AssetInfo.newUdtAsset((String)"0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd"));
            System.out.println(this.g.toJson((Object)builder.build()));
            GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void getBalanceByRecordByAddress() {
        try {
            Script script = AddressTools.parse((String)AddressWithKeyHolder.testAddress4()).script;
            CellResponse cells = this.getCells(script);
            GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
            builder.item(Item.newRecordItemByAddress((OutPoint)new OutPoint(cells.outPoint.txHash, cells.outPoint.index), (String)AddressWithKeyHolder.testAddress4()));
            builder.addAssetInfo(AssetInfo.newCkbAsset());
            System.out.println(this.g.toJson((Object)builder.build()));
            GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private CellResponse getCells(Script script) throws IOException {
        SearchKeyBuilder key = new SearchKeyBuilder();
        key.script(script);
        key.scriptType(ScriptType.lock);
        System.out.println(new Gson().toJson((Object)key.build()));
        CellsResponse cells = ApiFactory.getApi().getCells(key.build(), "asc", "0x" + new BigInteger("10").toString(16), null);
        if (cells.objects.size() > 0) {
            return (CellResponse)cells.objects.get(0);
        }
        return null;
    }
}

