/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.api.mercury;

import com.google.gson.Gson;
import constant.AddressWithKeyHolder;
import constant.ApiFactory;
import java.math.BigInteger;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.address.Network;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.AmountUtils;
import org.nervos.ckb.utils.address.AddressTools;
import org.nervos.mercury.model.SmartTransferPayloadBuilder;
import org.nervos.mercury.model.common.AssetInfo;
import org.nervos.mercury.model.req.ToInfo;
import org.nervos.mercury.model.resp.TransactionCompletionResponse;
import utils.SignUtils;

public class BuildSmartTransferTransactionTest {
    @Test
    void testCkbInsufficientBalanceToPayTheFee1() {
        try {
            AddressTools.AddressGenerateResult from = AddressTools.generateShortAddress((Network)Network.TESTNET);
            AddressTools.AddressGenerateResult to = AddressTools.generateShortAddress((Network)Network.TESTNET);
            SmartTransferPayloadBuilder builder = new SmartTransferPayloadBuilder();
            builder.addFrom(from.address);
            builder.addTo(new ToInfo(to.address, AmountUtils.ckbToShannon((long)100L)));
            builder.assetInfo(AssetInfo.newCkbAsset());
            ApiFactory.getApi().buildSmartTransferTransaction(builder.build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    void testCkbInsufficientBalanceToPayTheFee2() {
        try {
            AddressTools.AddressGenerateResult from = AddressTools.generateShortAddress((Network)Network.TESTNET);
            SmartTransferPayloadBuilder builder = new SmartTransferPayloadBuilder();
            builder.addFrom(from.address);
            builder.addTo(new ToInfo(AddressWithKeyHolder.testAddress4(), AmountUtils.ckbToShannon((long)100L)));
            builder.assetInfo(AssetInfo.newCkbAsset());
            ApiFactory.getApi().buildSmartTransferTransaction(builder.build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    void testSourceByClaimable() {
        SmartTransferPayloadBuilder builder = new SmartTransferPayloadBuilder();
        builder.addFrom(AddressWithKeyHolder.testAddress2());
        builder.addTo(new ToInfo(AddressWithKeyHolder.testAddress4(), new BigInteger("20")));
        builder.assetInfo(AssetInfo.newUdtAsset((String)"0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd"));
        System.out.println(new Gson().toJson((Object)builder.build()));
        try {
            TransactionCompletionResponse transactionCompletionResponse = ApiFactory.getApi().buildSmartTransferTransaction(builder.build());
            System.out.println(new Gson().toJson((Object)transactionCompletionResponse));
            Transaction tx = SignUtils.sign(transactionCompletionResponse);
            String hash = ApiFactory.getApi().sendTransaction(tx);
            System.out.println(hash);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    void testSourceByChequeCell() {
        try {
            AddressTools.AddressGenerateResult to = AddressTools.generateShortAddress((Network)Network.TESTNET);
            SmartTransferPayloadBuilder builder = new SmartTransferPayloadBuilder();
            builder.addFrom(AddressWithKeyHolder.testAddress2());
            builder.addTo(new ToInfo(to.address, new BigInteger("20")));
            builder.assetInfo(AssetInfo.newUdtAsset((String)"0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd"));
            System.out.println(new Gson().toJson((Object)builder.build()));
            TransactionCompletionResponse transactionCompletionResponse = ApiFactory.getApi().buildSmartTransferTransaction(builder.build());
            Transaction tx = SignUtils.sign(transactionCompletionResponse);
            String hash = ApiFactory.getApi().sendTransaction(tx);
            System.out.println(hash);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    void testSourceByFree() {
        SmartTransferPayloadBuilder builder = new SmartTransferPayloadBuilder();
        builder.addFrom(AddressWithKeyHolder.testAddress4());
        builder.addTo(new ToInfo(AddressWithKeyHolder.testAddress1(), new BigInteger("20")));
        builder.assetInfo(AssetInfo.newUdtAsset((String)"0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd"));
        System.out.println(new Gson().toJson((Object)builder.build()));
        try {
            TransactionCompletionResponse transactionCompletionResponse = ApiFactory.getApi().buildSmartTransferTransaction(builder.build());
            Transaction tx = SignUtils.sign(transactionCompletionResponse);
            String hash = ApiFactory.getApi().sendTransaction(tx);
            System.out.println(hash);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    void testModeByHoldyTo() {
        SmartTransferPayloadBuilder builder = new SmartTransferPayloadBuilder();
        builder.addFrom(AddressWithKeyHolder.testAddress1());
        builder.addTo(new ToInfo(AddressTools.generateAcpAddress((String)AddressWithKeyHolder.testAddress4()), new BigInteger("20")));
        builder.assetInfo(AssetInfo.newUdtAsset((String)"0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd"));
        System.out.println(new Gson().toJson((Object)builder.build()));
        try {
            TransactionCompletionResponse transactionCompletionResponse = ApiFactory.getApi().buildSmartTransferTransaction(builder.build());
            Transaction tx = SignUtils.sign(transactionCompletionResponse);
            String hash = ApiFactory.getApi().sendTransaction(tx);
            System.out.println(hash);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

