/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.api.mercury;

import com.google.gson.Gson;
import constant.AddressWithKeyHolder;
import constant.ApiFactory;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.AmountUtils;
import org.nervos.mercury.model.TransferPayloadBuilder;
import org.nervos.mercury.model.common.AssetInfo;
import org.nervos.mercury.model.req.From;
import org.nervos.mercury.model.req.Mode;
import org.nervos.mercury.model.req.Source;
import org.nervos.mercury.model.req.To;
import org.nervos.mercury.model.req.ToInfo;
import org.nervos.mercury.model.req.item.Item;
import org.nervos.mercury.model.resp.TransactionCompletionResponse;
import utils.SignUtils;

public class FeeRateTest {
    Gson g = new Gson();

    @Test
    void defaultFeeRate() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.assetInfo(AssetInfo.newCkbAsset());
        builder.from(From.newFrom(Arrays.asList(Item.newIdentityItemByAddress((String)AddressWithKeyHolder.testAddress0())), (Source)Source.Free));
        builder.to(To.newTo(Arrays.asList(new ToInfo(AddressWithKeyHolder.testAddress4(), AmountUtils.ckbToShannon((long)100L))), (Mode)Mode.HoldByFrom));
        try {
            TransactionCompletionResponse s = ApiFactory.getApi().buildTransferTransaction(builder.build());
            System.out.println(this.g.toJson((Object)s));
            Transaction tx = SignUtils.sign(s);
            String result = ApiFactory.getApi().sendTransaction(tx);
            System.out.println(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void customizedFeeRate() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.assetInfo(AssetInfo.newCkbAsset());
        builder.from(From.newFrom(Arrays.asList(Item.newIdentityItemByAddress((String)AddressWithKeyHolder.testAddress0())), (Source)Source.Free));
        builder.to(To.newTo(Arrays.asList(new ToInfo(AddressWithKeyHolder.testAddress4(), AmountUtils.ckbToShannon((long)100L))), (Mode)Mode.HoldByFrom));
        builder.feeRate(new BigInteger("10000"));
        try {
            TransactionCompletionResponse s = ApiFactory.getApi().buildTransferTransaction(builder.build());
            System.out.println(this.g.toJson((Object)s));
            Transaction tx = SignUtils.sign(s);
            String result = ApiFactory.getApi().sendTransaction(tx);
            System.out.println(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

