/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.api.mercury;

import com.google.gson.Gson;
import constant.AddressWithKeyHolder;
import constant.ApiFactory;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Objects;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.utils.address.AddressTools;
import org.nervos.mercury.model.QueryTransactionsPayloadBuilder;
import org.nervos.mercury.model.common.AssetInfo;
import org.nervos.mercury.model.common.ExtraFilterType;
import org.nervos.mercury.model.common.PaginationResponse;
import org.nervos.mercury.model.common.Range;
import org.nervos.mercury.model.req.item.Item;

public class QueryTransactionsTest {
    Gson g = new Gson();

    @Test
    void testQueryTransactionsWithCkb() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(Item.newIdentityItemByCkb((String)AddressWithKeyHolder.queryTransactionPubKey()));
            builder.addAssetInfo(AssetInfo.newCkbAsset());
            PaginationResponse resp = ApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryTransactionsWithUdt() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(Item.newIdentityItemByCkb((String)AddressWithKeyHolder.queryTransactionPubKey()));
            builder.addAssetInfo(AssetInfo.newUdtAsset((String)"0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd"));
            PaginationResponse resp = ApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryTransactionsWithAll() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(Item.newIdentityItemByCkb((String)AddressWithKeyHolder.queryTransactionPubKey()));
            PaginationResponse resp = ApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryTransactionsView() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(Item.newIdentityItemByCkb((String)AddressWithKeyHolder.queryTransactionPubKey()));
            builder.addAssetInfo(AssetInfo.newCkbAsset());
            PaginationResponse resp = ApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryTransactionsInfo() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(Item.newIdentityItemByCkb((String)AddressWithKeyHolder.queryTransactionPubKey()));
            builder.addAssetInfo(AssetInfo.newCkbAsset());
            PaginationResponse resp = ApiFactory.getApi().queryTransactionsWithTransactionInfo(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryTransactionsCellbase() {
        try {
            String minerAddress = "ckt1qyqd5eyygtdmwdr7ge736zw6z0ju6wsw7rssu8fcve";
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(Item.newAddressItem((String)minerAddress));
            builder.addAssetInfo(AssetInfo.newCkbAsset());
            builder.extraFilter(ExtraFilterType.CellBase);
            builder.limit(BigInteger.valueOf(3L));
            PaginationResponse resp = ApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryTransactionsDao() {
        try {
            String daoAddress = AddressWithKeyHolder.testAddress3();
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(Item.newAddressItem((String)daoAddress));
            builder.addAssetInfo(AssetInfo.newCkbAsset());
            builder.extraFilter(ExtraFilterType.Dao);
            builder.limit(BigInteger.valueOf(10L));
            PaginationResponse resp = ApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryTransactionsWithFromBlockAndToBlock() {
        try {
            Script script = AddressTools.parse((String)AddressWithKeyHolder.queryTransactionAddress()).script;
            System.out.println(script.computeHash());
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(Item.newIdentityItemByCkb((String)AddressWithKeyHolder.queryTransactionPubKey()));
            builder.range(new Range(new BigInteger("2778110"), new BigInteger("2778201")));
            PaginationResponse resp = ApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryTransactionsWithLimit() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(Item.newIdentityItemByCkb((String)AddressWithKeyHolder.queryTransactionPubKey()));
            builder.limit(new BigInteger("2"));
            PaginationResponse resp = ApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryTransactionsWithOrder() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(Item.newIdentityItemByCkb((String)AddressWithKeyHolder.queryTransactionPubKey()));
            builder.order("asc");
            PaginationResponse resp = ApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryTransactionsWithTotalCount() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(Item.newIdentityItemByCkb((String)AddressWithKeyHolder.queryTransactionPubKey()));
            builder.limit(new BigInteger("1"));
            builder.returnCount(Boolean.valueOf(true));
            PaginationResponse resp = ApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(resp.response.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryTransactionsWithPage1() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(Item.newIdentityItemByCkb((String)AddressWithKeyHolder.queryTransactionPubKey()));
            builder.limit(new BigInteger("1"));
            builder.returnCount(Boolean.valueOf(true));
            PaginationResponse resp = ApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(new Gson().toJson((Object)resp));
            if (Objects.isNull(resp.nextCursor)) {
                return;
            }
            while (Objects.nonNull(resp.nextCursor)) {
                QueryTransactionsPayloadBuilder builder2 = new QueryTransactionsPayloadBuilder();
                builder2.item(Item.newIdentityItemByCkb((String)AddressWithKeyHolder.queryTransactionPubKey()));
                builder2.limit(new BigInteger("1"));
                builder2.returnCount(Boolean.valueOf(true));
                System.out.println(resp.nextCursor);
                builder2.cursor(resp.nextCursor);
                System.out.println(new Gson().toJson((Object)builder2.build()));
                resp = ApiFactory.getApi().queryTransactionsWithTransactionView(builder2.build());
                System.out.println(new Gson().toJson((Object)resp));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryTransactionsWithPage2() {
        try {
            QueryTransactionsPayloadBuilder builder = new QueryTransactionsPayloadBuilder();
            builder.item(Item.newIdentityItemByCkb((String)AddressWithKeyHolder.queryTransactionPubKey()));
            builder.limit(new BigInteger("1"));
            builder.pageNumber(BigInteger.valueOf(3L));
            builder.returnCount(Boolean.valueOf(true));
            PaginationResponse resp = ApiFactory.getApi().queryTransactionsWithTransactionView(builder.build());
            System.out.println(new Gson().toJson((Object)resp));
            if (Objects.isNull(resp.nextCursor)) {
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

