/*
 * Decompiled with CFR 0.152.
 */
package utils;

import constant.AddressWithKeyHolder;
import java.io.IOException;
import java.util.List;
import org.nervos.ckb.transaction.ScriptGroup;
import org.nervos.ckb.transaction.Secp256k1SighashAllBuilder;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.mercury.model.resp.MercuryScriptGroup;
import org.nervos.mercury.model.resp.TransactionCompletionResponse;

public class SignUtils {
    public static Transaction sign(TransactionCompletionResponse s) throws IOException {
        List scriptGroups = s.getScriptGroup();
        Secp256k1SighashAllBuilder signBuilder = new Secp256k1SighashAllBuilder(s.txView);
        for (MercuryScriptGroup sg : scriptGroups) {
            signBuilder.sign((ScriptGroup)sg, AddressWithKeyHolder.getKey(sg.pubKey));
        }
        Transaction tx = signBuilder.buildTx();
        return tx;
    }

    public static Transaction signByKey(TransactionCompletionResponse s, String key) throws IOException {
        List scriptGroups = s.getScriptGroup();
        Secp256k1SighashAllBuilder signBuilder = new Secp256k1SighashAllBuilder(s.txView);
        for (MercuryScriptGroup sg : scriptGroups) {
            signBuilder.sign((ScriptGroup)sg, key);
        }
        Transaction tx = signBuilder.buildTx();
        return tx;
    }
}

