/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.api.mercury;

import com.google.gson.Gson;
import constant.AddressWithKeyHolder;
import constant.ApiFactory;
import java.io.IOException;
import java.math.BigInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.utils.address.AddressTools;
import org.nervos.indexer.model.ScriptType;
import org.nervos.indexer.model.SearchKeyBuilder;
import org.nervos.indexer.model.resp.CellResponse;
import org.nervos.indexer.model.resp.CellsResponse;
import org.nervos.mercury.GsonFactory;
import org.nervos.mercury.model.GetBalancePayloadBuilder;
import org.nervos.mercury.model.common.AssetInfo;
import org.nervos.mercury.model.req.item.ItemFactory;
import org.nervos.mercury.model.resp.GetBalanceResponse;

public class BalanceTest {
    Gson g = GsonFactory.newGson();

    @Test
    void getCkbBalance() {
        try {
            GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
            builder.item(ItemFactory.newIdentityItemByCkb((String)AddressWithKeyHolder.testPubKey4()));
            builder.addAssetInfo(AssetInfo.newCkbAsset());
            System.out.println(this.g.toJson((Object)builder.build()));
            GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void getSudtBalance() {
        GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
        builder.item(ItemFactory.newIdentityItemByCkb((String)AddressWithKeyHolder.testPubKey4()));
        builder.addAssetInfo(AssetInfo.newUdtAsset((String)"0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd"));
        System.out.println(this.g.toJson((Object)builder.build()));
        try {
            GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void getAllBalance() {
        GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
        builder.item(ItemFactory.newIdentityItemByCkb((String)AddressWithKeyHolder.testPubKey4()));
        System.out.println(this.g.toJson((Object)builder.build()));
        try {
            GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
            System.out.println(balance.balances.size());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void getBalanceByAddress() {
        try {
            GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
            builder.item(ItemFactory.newAddressItem((String)AddressWithKeyHolder.testAddress4()));
            builder.addAssetInfo(AssetInfo.newCkbAsset());
            System.out.println(this.g.toJson((Object)builder.build()));
            GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void getBalanceByIdentity() {
        try {
            GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
            builder.item(ItemFactory.newIdentityItemByCkb((String)AddressWithKeyHolder.testPubKey4()));
            builder.addAssetInfo(AssetInfo.newUdtAsset((String)"0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd"));
            System.out.println(this.g.toJson((Object)builder.build()));
            GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void getBalanceByRecordByScriptByChequeCellSender() {
        try {
            GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
            builder.item(ItemFactory.newOutPointItem((String)"0x52b1cf0ad857d53e1a3552944c1acf268f6a6aea8e8fc85fe8febcb8127d56f0", (String)"0x0"));
            builder.addAssetInfo(AssetInfo.newCkbAsset());
            System.out.println(this.g.toJson((Object)builder.build()));
            GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void getBalanceByRecordByScriptChequeCellReceiver() {
        try {
            GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
            builder.item(ItemFactory.newOutPointItem((String)"0x52b1cf0ad857d53e1a3552944c1acf268f6a6aea8e8fc85fe8febcb8127d56f0", (String)"0x0"));
            builder.addAssetInfo(AssetInfo.newUdtAsset((String)"0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd"));
            System.out.println(this.g.toJson((Object)builder.build()));
            GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void getBalanceByRecordByAddress() {
        try {
            Script script = AddressTools.parse((String)AddressWithKeyHolder.testAddress4()).script;
            CellResponse cells = this.getCells(script);
            GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
            builder.item(ItemFactory.newOutPointItem((String)cells.outPoint.txHash, (String)cells.outPoint.index));
            builder.addAssetInfo(AssetInfo.newCkbAsset());
            System.out.println(this.g.toJson((Object)builder.build()));
            GetBalanceResponse balance = ApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CellResponse getCells(Script script) throws IOException {
        SearchKeyBuilder key = new SearchKeyBuilder();
        key.script(script);
        key.scriptType(ScriptType.lock);
        System.out.println(this.g.toJson((Object)key.build()));
        CellsResponse cells = ApiFactory.getApi().getCells(key.build(), "asc", "0x" + new BigInteger("10").toString(16), null);
        if (cells.objects.size() > 0) {
            return (CellResponse)cells.objects.get(0);
        }
        return null;
    }
}

