/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.api;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.nervos.api.CkbApi;
import org.nervos.ckb.CkbRpcApi;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.service.RpcResponse;
import org.nervos.ckb.service.RpcService;
import org.nervos.ckb.sign.TransactionWithScriptGroups;
import org.nervos.ckb.type.BannedAddress;
import org.nervos.ckb.type.BannedResultAddress;
import org.nervos.ckb.type.Block;
import org.nervos.ckb.type.BlockEconomicState;
import org.nervos.ckb.type.BlockchainInfo;
import org.nervos.ckb.type.CellWithStatus;
import org.nervos.ckb.type.Consensus;
import org.nervos.ckb.type.Cycles;
import org.nervos.ckb.type.Epoch;
import org.nervos.ckb.type.Header;
import org.nervos.ckb.type.NodeInfo;
import org.nervos.ckb.type.OutPoint;
import org.nervos.ckb.type.OutputsValidator;
import org.nervos.ckb.type.PeerNodeInfo;
import org.nervos.ckb.type.RawTxPool;
import org.nervos.ckb.type.RawTxPoolVerbose;
import org.nervos.ckb.type.SyncState;
import org.nervos.ckb.type.Transaction;
import org.nervos.ckb.type.TransactionProof;
import org.nervos.ckb.type.TransactionWithStatus;
import org.nervos.ckb.type.TxPoolInfo;
import org.nervos.indexer.CkbIndexerApi;
import org.nervos.indexer.DefaultIndexerApi;
import org.nervos.indexer.model.Order;
import org.nervos.indexer.model.SearchKey;
import org.nervos.indexer.model.resp.CellCapacityResponse;
import org.nervos.indexer.model.resp.CellsResponse;
import org.nervos.indexer.model.resp.TipResponse;
import org.nervos.indexer.model.resp.TransactionResponse;
import org.nervos.mercury.DefaultMercuryApi;
import org.nervos.mercury.MercuryApi;
import org.nervos.mercury.model.common.PaginationResponse;
import org.nervos.mercury.model.req.payload.AccountInfoPayload;
import org.nervos.mercury.model.req.payload.AdjustAccountPayload;
import org.nervos.mercury.model.req.payload.DaoClaimPayload;
import org.nervos.mercury.model.req.payload.DaoDepositPayload;
import org.nervos.mercury.model.req.payload.DaoWithdrawPayload;
import org.nervos.mercury.model.req.payload.GetBalancePayload;
import org.nervos.mercury.model.req.payload.GetBlockInfoPayload;
import org.nervos.mercury.model.req.payload.GetSpentTransactionPayload;
import org.nervos.mercury.model.req.payload.QueryTransactionsPayload;
import org.nervos.mercury.model.req.payload.SimpleTransferPayload;
import org.nervos.mercury.model.req.payload.SudtIssuePayload;
import org.nervos.mercury.model.req.payload.TransferPayload;
import org.nervos.mercury.model.resp.AccountInfo;
import org.nervos.mercury.model.resp.BlockInfoResponse;
import org.nervos.mercury.model.resp.GetBalanceResponse;
import org.nervos.mercury.model.resp.GetTransactionInfoResponse;
import org.nervos.mercury.model.resp.TransactionInfoResponse;
import org.nervos.mercury.model.resp.TransactionWithRichStatus;
import org.nervos.mercury.model.resp.TxView;
import org.nervos.mercury.model.resp.info.DBInfo;
import org.nervos.mercury.model.resp.info.MercuryInfo;
import org.nervos.mercury.model.resp.info.MercurySyncState;

public class DefaultCkbApi
implements CkbApi {
    private CkbRpcApi ckbApi;
    private MercuryApi mercuryApi;
    private CkbIndexerApi ckbIndexerApi;

    public DefaultCkbApi(String ckbUrl, String mercuryUrl, String indexerUrl, boolean isDebug) {
        if (Objects.nonNull(ckbUrl)) {
            this.ckbApi = new Api(new RpcService(ckbUrl, isDebug));
        }
        if (Objects.nonNull(indexerUrl)) {
            this.ckbIndexerApi = new DefaultIndexerApi(new RpcService(indexerUrl, isDebug));
        }
        if (Objects.nonNull(mercuryUrl)) {
            this.mercuryApi = new DefaultMercuryApi(new RpcService(mercuryUrl, isDebug));
        }
    }

    public TipResponse getTip() throws IOException {
        if (this.mercuryApi != null) {
            return this.mercuryApi.getTip();
        }
        if (this.ckbIndexerApi != null) {
            return this.ckbIndexerApi.getTip();
        }
        return null;
    }

    public CellsResponse getCells(SearchKey searchKey, Order order, int limit, byte[] afterCursor) throws IOException {
        if (this.mercuryApi != null) {
            // empty if block
        }
        if (this.ckbIndexerApi != null) {
            return this.ckbIndexerApi.getCells(searchKey, order, limit, afterCursor);
        }
        return null;
    }

    public TransactionResponse getTransactions(SearchKey searchKey, Order order, int limit, byte[] afterCursor) throws IOException {
        if (this.mercuryApi != null) {
            // empty if block
        }
        if (this.ckbIndexerApi != null) {
            return this.ckbIndexerApi.getTransactions(searchKey, order, limit, afterCursor);
        }
        return null;
    }

    public CellCapacityResponse getCellsCapacity(SearchKey searchKey) throws IOException {
        if (this.mercuryApi != null) {
            return this.mercuryApi.getCellsCapacity(searchKey);
        }
        if (this.ckbIndexerApi != null) {
            return this.ckbIndexerApi.getCellsCapacity(searchKey);
        }
        return null;
    }

    public Block getBlock(byte[] blockHash) throws IOException {
        return this.ckbApi.getBlock(blockHash);
    }

    public Block getBlockByNumber(long blockNumber) throws IOException {
        return this.ckbApi.getBlockByNumber(blockNumber);
    }

    public TransactionWithStatus getTransaction(byte[] transactionHash) throws IOException {
        return this.ckbApi.getTransaction(transactionHash);
    }

    public byte[] getBlockHash(long blockNumber) throws IOException {
        return this.ckbApi.getBlockHash(blockNumber);
    }

    public BlockEconomicState getBlockEconomicState(byte[] blockHash) throws IOException {
        return this.ckbApi.getBlockEconomicState(blockHash);
    }

    public Header getTipHeader() throws IOException {
        return this.ckbApi.getTipHeader();
    }

    public CellWithStatus getLiveCell(OutPoint outPoint, boolean withData) throws IOException {
        return this.ckbApi.getLiveCell(outPoint, withData);
    }

    public long getTipBlockNumber() throws IOException {
        return this.ckbApi.getTipBlockNumber();
    }

    public Epoch getCurrentEpoch() throws IOException {
        return this.ckbApi.getCurrentEpoch();
    }

    public Epoch getEpochByNumber(long epochNumber) throws IOException {
        return this.ckbApi.getEpochByNumber(epochNumber);
    }

    public Header getHeader(byte[] blockHash) throws IOException {
        return this.ckbApi.getHeader(blockHash);
    }

    public Header getHeaderByNumber(long blockNumber) throws IOException {
        return this.ckbApi.getHeaderByNumber(blockNumber);
    }

    public TransactionProof getTransactionProof(List<byte[]> txHashes) throws IOException {
        return this.ckbApi.getTransactionProof(txHashes);
    }

    public TransactionProof getTransactionProof(List<byte[]> txHashes, byte[] blockHash) throws IOException {
        return this.ckbApi.getTransactionProof(txHashes, blockHash);
    }

    public List<byte[]> verifyTransactionProof(TransactionProof transactionProof) throws IOException {
        return this.ckbApi.verifyTransactionProof(transactionProof);
    }

    public Block getForkBlock(byte[] blockHash) throws IOException {
        return this.ckbApi.getForkBlock(blockHash);
    }

    public Consensus getConsensus() throws IOException {
        return this.ckbApi.getConsensus();
    }

    public long getBlockMedianTime(byte[] blockHash) throws IOException {
        return this.ckbApi.getBlockMedianTime(blockHash);
    }

    public BlockchainInfo getBlockchainInfo() throws IOException {
        return this.ckbApi.getBlockchainInfo();
    }

    public TxPoolInfo txPoolInfo() throws IOException {
        return this.ckbApi.txPoolInfo();
    }

    public void clearTxPool() throws IOException {
        this.ckbApi.clearTxPool();
    }

    public RawTxPool getRawTxPool() throws IOException {
        return this.ckbApi.getRawTxPool();
    }

    public RawTxPoolVerbose getRawTxPoolVerbose() throws IOException {
        return this.ckbApi.getRawTxPoolVerbose();
    }

    public byte[] sendTransaction(Transaction transaction) throws IOException {
        return this.ckbApi.sendTransaction(transaction);
    }

    public byte[] sendTransaction(Transaction transaction, OutputsValidator outputsValidator) throws IOException {
        return this.ckbApi.sendTransaction(transaction, outputsValidator);
    }

    public NodeInfo localNodeInfo() throws IOException {
        return this.ckbApi.localNodeInfo();
    }

    public List<PeerNodeInfo> getPeers() throws IOException {
        return this.ckbApi.getPeers();
    }

    public SyncState syncState() throws IOException {
        return this.ckbApi.syncState();
    }

    public void setNetworkActive(boolean state) throws IOException {
        this.ckbApi.setNetworkActive(state);
    }

    public void addNode(String peerId, String address) throws IOException {
        this.ckbApi.addNode(peerId, address);
    }

    public void removeNode(String peerId) throws IOException {
        this.ckbApi.removeNode(peerId);
    }

    public void setBan(BannedAddress bannedAddress) throws IOException {
        this.ckbApi.setBan(bannedAddress);
    }

    public List<BannedResultAddress> getBannedAddresses() throws IOException {
        return this.ckbApi.getBannedAddresses();
    }

    public void clearBannedAddresses() throws IOException {
        this.ckbApi.clearBannedAddresses();
    }

    public void pingPeers() throws IOException {
        this.ckbApi.pingPeers();
    }

    public Cycles dryRunTransaction(Transaction transaction) throws IOException {
        return this.ckbApi.dryRunTransaction(transaction);
    }

    public long calculateDaoMaximumWithdraw(OutPoint outPoint, byte[] withdrawBlockHash) throws IOException {
        return this.ckbApi.calculateDaoMaximumWithdraw(outPoint, withdrawBlockHash);
    }

    public List<RpcResponse> batchRPC(List<List> requests) throws IOException {
        return this.ckbApi.batchRPC(requests);
    }

    public GetBalanceResponse getBalance(GetBalancePayload payload) throws IOException {
        return this.mercuryApi.getBalance(payload);
    }

    public AccountInfo getAccountInfo(AccountInfoPayload payload) throws IOException {
        return this.mercuryApi.getAccountInfo(payload);
    }

    public TransactionWithScriptGroups buildTransferTransaction(TransferPayload payload) throws IOException {
        return this.mercuryApi.buildTransferTransaction(payload);
    }

    public TransactionWithScriptGroups buildAdjustAccountTransaction(AdjustAccountPayload payload) throws IOException {
        return this.mercuryApi.buildAdjustAccountTransaction(payload);
    }

    public TransactionWithScriptGroups buildSimpleTransferTransaction(SimpleTransferPayload payload) throws IOException {
        return this.mercuryApi.buildSimpleTransferTransaction(payload);
    }

    public GetTransactionInfoResponse getTransactionInfo(byte[] txHash) throws IOException {
        return this.mercuryApi.getTransactionInfo(txHash);
    }

    public BlockInfoResponse getBlockInfo(GetBlockInfoPayload payload) throws IOException {
        return this.mercuryApi.getBlockInfo(payload);
    }

    public List<byte[]> registerAddresses(List<String> normalAddresses) throws IOException {
        return this.mercuryApi.registerAddresses(normalAddresses);
    }

    public PaginationResponse<TransactionWithRichStatus> queryTransactionsWithTransactionView(QueryTransactionsPayload payload) throws IOException {
        return this.mercuryApi.queryTransactionsWithTransactionView(payload);
    }

    public PaginationResponse<TransactionInfoResponse> queryTransactionsWithTransactionInfo(QueryTransactionsPayload payload) throws IOException {
        return this.mercuryApi.queryTransactionsWithTransactionInfo(payload);
    }

    public DBInfo getDbInfo() throws IOException {
        return this.mercuryApi.getDbInfo();
    }

    public MercuryInfo getMercuryInfo() throws IOException {
        return this.mercuryApi.getMercuryInfo();
    }

    public MercurySyncState getSyncState() throws IOException {
        return this.mercuryApi.getSyncState();
    }

    public TxView<TransactionWithRichStatus> getSpentTransactionWithTransactionView(GetSpentTransactionPayload payload) throws IOException {
        return this.mercuryApi.getSpentTransactionWithTransactionView(payload);
    }

    public TxView<TransactionInfoResponse> getSpentTransactionWithTransactionInfo(GetSpentTransactionPayload payload) throws IOException {
        return this.mercuryApi.getSpentTransactionWithTransactionInfo(payload);
    }

    public TransactionWithScriptGroups buildDaoDepositTransaction(DaoDepositPayload payload) throws IOException {
        return this.mercuryApi.buildDaoDepositTransaction(payload);
    }

    public TransactionWithScriptGroups buildDaoWithdrawTransaction(DaoWithdrawPayload payload) throws IOException {
        return this.mercuryApi.buildDaoWithdrawTransaction(payload);
    }

    public TransactionWithScriptGroups buildDaoClaimTransaction(DaoClaimPayload payload) throws IOException {
        return this.mercuryApi.buildDaoClaimTransaction(payload);
    }

    public TransactionWithScriptGroups buildSudtIssueTransaction(SudtIssuePayload payload) throws IOException {
        return this.mercuryApi.buildSudtIssueTransaction(payload);
    }
}

