/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.indexer.model;

import java.util.ArrayList;
import org.nervos.ckb.type.Script;
import org.nervos.indexer.model.Filter;
import org.nervos.indexer.model.ScriptType;
import org.nervos.indexer.model.SearchKey;

public class SearchKeyBuilder {
    private Script script;
    private ScriptType scriptType;
    private Filter filter;

    public void script(Script script) {
        this.script = script;
    }

    public void scriptType(ScriptType scriptType) {
        this.scriptType = scriptType;
    }

    public void filterScript(Script script) {
        this.initFilter();
        this.filter.script = script;
    }

    public void filterOutputDataLenRange(String inclusive, String exclusive) {
        this.initFilter();
        this.filter.outputDataLenRange = new ArrayList<String>(2);
        this.filter.outputDataLenRange.add(inclusive);
        this.filter.outputDataLenRange.add(exclusive);
    }

    public void filterOutputCapacityRange(String inclusive, String exclusive) {
        this.initFilter();
        this.filter.outputCapacityRange = new ArrayList<String>(2);
        this.filter.outputCapacityRange.add(inclusive);
        this.filter.outputCapacityRange.add(exclusive);
    }

    public void filterBlockRange(String inclusive, String exclusive) {
        this.initFilter();
        this.filter.blockRange = new ArrayList<String>(2);
        this.filter.blockRange.add(inclusive);
        this.filter.blockRange.add(exclusive);
    }

    public SearchKey build() {
        SearchKey searchKey = new SearchKey();
        searchKey.script = this.script;
        searchKey.scriptType = this.scriptType;
        searchKey.filter = this.filter;
        return searchKey;
    }

    private void initFilter() {
        if (this.filter == null) {
            this.filter = new Filter();
        }
    }
}

