/*
 * Decompiled with CFR 0.152.
 */
package indexer;

import com.google.gson.Gson;
import indexer.CkbIndexerApi;
import indexer.model.SearchKey;
import indexer.model.resp.CellCapacityResp;
import indexer.model.resp.CellsResp;
import indexer.model.resp.TipResp;
import indexer.model.resp.TransactionResp;
import java.io.IOException;
import java.util.Arrays;
import org.nervos.ckb.service.RpcService;

public class DefaultIndexerApi
implements CkbIndexerApi {
    protected RpcService rpcService;
    private Gson gson = new Gson();

    public DefaultIndexerApi(String mercuryUrl, boolean isDebug) {
        this.rpcService = new RpcService(mercuryUrl, isDebug);
    }

    @Override
    public TipResp getTip() throws IOException {
        return (TipResp)this.rpcService.post("get_tip", Arrays.asList(new Object[0]), TipResp.class);
    }

    @Override
    public CellsResp getCells(SearchKey searchKey, String order, String limit, String afterCursor) throws IOException {
        return (CellsResp)this.rpcService.post("get_cells", Arrays.asList(searchKey, order, limit, afterCursor), CellsResp.class);
    }

    @Override
    public TransactionResp getTransactions(SearchKey searchKey, String order, String limit, String afterCursor) throws IOException {
        return (TransactionResp)this.rpcService.post("get_transactions", Arrays.asList(searchKey, order, limit, afterCursor), TransactionResp.class);
    }

    @Override
    public CellCapacityResp getCellsCapacity(SearchKey searchKey) throws IOException {
        return (CellCapacityResp)this.rpcService.post("get_cells_capacity", Arrays.asList(searchKey), CellCapacityResp.class);
    }
}

