/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.indexer.model;

import java.util.ArrayList;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.ScriptType;
import org.nervos.indexer.model.Filter;
import org.nervos.indexer.model.ScriptSearchMode;
import org.nervos.indexer.model.SearchKey;

public class SearchKeyBuilder {
    private Script script;
    private ScriptType scriptType;
    private Filter filter;
    private ScriptSearchMode _scriptSearchMode;
    private Boolean _withData;

    public SearchKeyBuilder script(Script script) {
        this.script = script;
        return this;
    }

    public SearchKeyBuilder scriptType(ScriptType scriptType) {
        this.scriptType = scriptType;
        return this;
    }

    public SearchKeyBuilder filterScript(Script script) {
        this.initFilter();
        this.filter.script = script;
        return this;
    }

    public SearchKeyBuilder filterOutputDataLenRange(int inclusive, int exclusive) {
        this.initFilter();
        this.filter.outputDataLenRange = new ArrayList<Integer>(2);
        this.filter.outputDataLenRange.add(inclusive);
        this.filter.outputDataLenRange.add(exclusive);
        return this;
    }

    public SearchKeyBuilder filterOutputCapacityRange(long inclusive, long exclusive) {
        this.initFilter();
        this.filter.outputCapacityRange = new ArrayList<Long>(2);
        this.filter.outputCapacityRange.add(inclusive);
        this.filter.outputCapacityRange.add(exclusive);
        return this;
    }

    public SearchKeyBuilder filterBlockRange(int inclusive, int exclusive) {
        this.initFilter();
        this.filter.blockRange = new ArrayList<Integer>(2);
        this.filter.blockRange.add(inclusive);
        this.filter.blockRange.add(exclusive);
        return this;
    }

    public SearchKeyBuilder scriptSearchMode(ScriptSearchMode scriptSearchMode) {
        this._scriptSearchMode = scriptSearchMode;
        return this;
    }

    public SearchKeyBuilder withData(Boolean withData) {
        this._withData = withData;
        return this;
    }

    public SearchKey build() {
        SearchKey searchKey = new SearchKey();
        searchKey.script = this.script;
        searchKey.scriptType = this.scriptType;
        searchKey.filter = this.filter;
        searchKey.scriptSearchMode = this._scriptSearchMode;
        searchKey.withData = this._withData;
        return searchKey;
    }

    private void initFilter() {
        if (this.filter == null) {
            this.filter = new Filter();
        }
    }
}

