/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.indexer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.nervos.ckb.service.RpcService;
import org.nervos.indexer.CkbIndexerApi;
import org.nervos.indexer.Configuration;
import org.nervos.indexer.IndexerType;
import org.nervos.indexer.model.Order;
import org.nervos.indexer.model.SearchKey;
import org.nervos.indexer.model.resp.CellCapacityResponse;
import org.nervos.indexer.model.resp.CellsResponse;
import org.nervos.indexer.model.resp.TipResponse;
import org.nervos.indexer.model.resp.TxsWithCell;
import org.nervos.indexer.model.resp.TxsWithCells;

public class DefaultIndexerApi
implements CkbIndexerApi {
    protected RpcService rpcService;

    public DefaultIndexerApi(String indexerUrl, boolean isDebug) {
        this.rpcService = new RpcService(indexerUrl, isDebug);
    }

    public DefaultIndexerApi(RpcService rpcService) {
        this.rpcService = rpcService;
    }

    @Override
    public TipResponse getTip() throws IOException {
        String method;
        IndexerType type = Configuration.getInstance().getIndexerType();
        switch (type) {
            case StandAlone: {
                method = "get_tip";
                break;
            }
            case CkbModule: {
                method = "get_indexer_tip";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported index type:" + (Object)((Object)type));
            }
        }
        return (TipResponse)this.rpcService.post(method, Collections.emptyList(), TipResponse.class);
    }

    @Override
    public CellsResponse getCells(SearchKey searchKey, Order order, int limit, byte[] afterCursor) throws IOException {
        return (CellsResponse)this.rpcService.post("get_cells", Arrays.asList(new Object[]{searchKey, order, limit, afterCursor}), CellsResponse.class);
    }

    @Override
    public TxsWithCell getTransactions(SearchKey searchKey, Order order, int limit, byte[] afterCursor) throws IOException {
        searchKey.groupByTransaction = false;
        return (TxsWithCell)this.rpcService.post("get_transactions", Arrays.asList(new Object[]{searchKey, order, limit, afterCursor}), TxsWithCell.class);
    }

    @Override
    public TxsWithCells getTransactionsGrouped(SearchKey searchKey, Order order, int limit, byte[] afterCursor) throws IOException {
        searchKey.groupByTransaction = true;
        return (TxsWithCells)this.rpcService.post("get_transactions", Arrays.asList(new Object[]{searchKey, order, limit, afterCursor}), TxsWithCells.class);
    }

    @Override
    public CellCapacityResponse getCellsCapacity(SearchKey searchKey) throws IOException {
        return (CellCapacityResponse)this.rpcService.post("get_cells_capacity", Arrays.asList(searchKey), CellCapacityResponse.class);
    }
}

