/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.indexer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.nervos.ckb.Network;
import org.nervos.ckb.type.CellInput;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.ScriptType;
import org.nervos.ckb.type.TransactionInput;
import org.nervos.ckb.utils.address.Address;
import org.nervos.indexer.CkbIndexerApi;
import org.nervos.indexer.Configuration;
import org.nervos.indexer.DefaultIndexerApi;
import org.nervos.indexer.model.Filter;
import org.nervos.indexer.model.Order;
import org.nervos.indexer.model.SearchKey;
import org.nervos.indexer.model.resp.CellResponse;
import org.nervos.indexer.model.resp.CellsResponse;

public class InputIterator
implements Iterator<TransactionInput> {
    private List<TransactionInput> transactionInputs = new ArrayList<TransactionInput>();
    private TransactionInput current;
    private byte[] afterCursor;
    private CkbIndexerApi indexerApi;
    private int inputIndex = 0;
    private int searchKeysIndex = 0;
    private List<SearchKey> searchKeys = new ArrayList<SearchKey>();
    private Order order = Order.ASC;
    private Integer limit = 100;

    public InputIterator(CkbIndexerApi indexerApi, Order order, Integer limit) {
        this.indexerApi = indexerApi;
        this.order = order;
        this.limit = limit;
    }

    public InputIterator(CkbIndexerApi api) {
        this.indexerApi = api;
    }

    public InputIterator(String address) {
        this(InputIterator.getDefaultIndexerApi(Address.decode((String)address).getNetwork()));
        this.addSearchKey(address);
    }

    public InputIterator addSearchKey(String address) {
        return this.addSearchKey(address, null);
    }

    public InputIterator addSearchKey(String address, Script type) {
        Script lockScript = Address.decode((String)address).getScript();
        SearchKey searchKey = new SearchKey();
        searchKey.scriptType = ScriptType.LOCK;
        searchKey.script = lockScript;
        if (type != null) {
            Filter filter = new Filter();
            filter.script = type;
            searchKey.filter = filter;
        }
        this.searchKeys.add(searchKey);
        return this;
    }

    public InputIterator addSudtSearchKey(String address, byte[] sudtArgs) {
        byte[] codeHash;
        Address addr = Address.decode((String)address);
        Network network = addr.getNetwork();
        if (network == Network.TESTNET) {
            codeHash = Script.SUDT_CODE_HASH_TESTNET;
        } else if (network == Network.MAINNET) {
            codeHash = Script.SUDT_CODE_HASH_MAINNET;
        } else {
            throw new IllegalArgumentException("Unsupported network");
        }
        Script type = new Script(codeHash, sudtArgs, Script.HashType.TYPE);
        return this.addSearchKey(address, type);
    }

    private static CkbIndexerApi getDefaultIndexerApi(Network network) {
        String url = Configuration.getInstance().getIndexerType().getUrl(network);
        return new DefaultIndexerApi(url, false);
    }

    @Override
    public boolean hasNext() {
        this.updateCurrent();
        return this.current != null;
    }

    @Override
    public TransactionInput next() {
        this.updateCurrent();
        if (this.current != null) {
            ++this.inputIndex;
            return this.current;
        }
        throw new NoSuchElementException();
    }

    private void updateCurrent() {
        this.current = this.inputIndex < this.transactionInputs.size() ? this.transactionInputs.get(this.inputIndex) : null;
        while (this.current == null && this.searchKeysIndex < this.searchKeys.size()) {
            SearchKey searchKey = this.searchKeys.get(this.searchKeysIndex);
            try {
                this.fetchTransactionInputs(searchKey);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.transactionInputs.isEmpty()) {
                this.afterCursor = null;
                ++this.searchKeysIndex;
                continue;
            }
            this.inputIndex = 0;
            this.current = this.transactionInputs.get(0);
        }
    }

    private void fetchTransactionInputs(SearchKey searchKey) throws IOException {
        CellsResponse response = this.indexerApi.getCells(searchKey, this.order, this.limit, this.afterCursor);
        ArrayList<TransactionInput> newTransactionInputs = new ArrayList<TransactionInput>();
        for (CellResponse liveCell : response.objects) {
            CellInput cellInput = new CellInput(liveCell.outPoint);
            newTransactionInputs.add(new TransactionInput(cellInput, liveCell.output, liveCell.outputData));
        }
        this.transactionInputs = newTransactionInputs;
        this.afterCursor = response.lastCursor;
    }
}

