/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.mercury.model.resp;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import org.nervos.ckb.type.Witness;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.mercury.model.resp.MercuryScriptGroup;
import org.nervos.mercury.model.resp.SignatureEntry;

public class TransactionCompletionResponse {
    @SerializedName(value="tx_view")
    public Transaction txView;
    @SerializedName(value="signature_entries")
    public List<SignatureEntry> signatureEntries;

    public List<MercuryScriptGroup> getScriptGroup() {
        this.signaturePlaceholder();
        ArrayList<MercuryScriptGroup> scriptGroups = new ArrayList<MercuryScriptGroup>(this.signatureEntries.size());
        for (int i = 0; i < this.signatureEntries.size(); ++i) {
            MercuryScriptGroup sg = new MercuryScriptGroup(this.signatureEntries.get((int)i).pubKey, this.getInputIndexes(this.signatureEntries.get((int)i).index, this.signatureEntries.get((int)i).groupLen));
            scriptGroups.add(sg);
        }
        return scriptGroups;
    }

    private void signaturePlaceholder() {
        for (int i = 0; i < this.txView.inputs.size(); ++i) {
            this.txView.witnesses.add(this.is_sig_entry(i) ? new Witness("0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000") : "0x");
        }
    }

    private List<Integer> getInputIndexes(int index, int len) {
        ArrayList<Integer> integers = new ArrayList<Integer>();
        integers.add(index);
        int cnt = 1;
        for (int i = index + 1; i < this.txView.inputs.size() && cnt != len; ++i) {
            if (this.is_sig_entry(i)) continue;
            integers.add(i);
            ++cnt;
        }
        return integers;
    }

    private boolean is_sig_entry(int index) {
        for (int i = 0; i < this.signatureEntries.size(); ++i) {
            if (this.signatureEntries.get((int)i).index != index) continue;
            return true;
        }
        return false;
    }
}

