/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.mercury.model.req.item;

import org.nervos.ckb.type.OutPoint;
import org.nervos.ckb.type.Script;
import org.nervos.mercury.model.req.item.Address;
import org.nervos.mercury.model.req.item.Identity;
import org.nervos.mercury.model.req.item.Item;
import org.nervos.mercury.model.req.item.Record;

public class ItemFactory {
    public static Item newAddressItem(String address) {
        return new Item(Item.Type.ADDRESS, new Address(address));
    }

    public static Item newIdentityItemByCkb(String pubKey) {
        return new Item(Item.Type.IDENTITY, new Identity("0x00", pubKey));
    }

    public static Item newIdentityItemByAddress(String address) {
        return new Item(Item.Type.IDENTITY, Identity.toIdentityByAddress(address));
    }

    public static Item newRecordItemByScript(OutPoint point, Script script) {
        return new Item(Item.Type.RECORD, new Record(point, script));
    }

    public static Item newRecordItemByAddress(OutPoint point, String address) {
        return new Item(Item.Type.RECORD, new Record(point, address));
    }
}

