/*
 * Decompiled with CFR 0.152.
 */
package mercury;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.Arrays;
import mercury.MercuryApi;
import model.Action;
import model.CreateWalletPayload;
import model.TransferPayload;
import model.resp.GetBalanceResponse;
import model.resp.TransactionCompletionResponse;
import org.nervos.ckb.service.RpcService;

public class DefaultMercuryApi
implements MercuryApi {
    private RpcService rpcService;
    private Gson gson = new Gson();

    public DefaultMercuryApi(String mercuryUrl, boolean isDebug) {
        this.rpcService = new RpcService(mercuryUrl, isDebug);
    }

    @Override
    public GetBalanceResponse getBalance(String udtHash, String ident) throws IOException {
        return (GetBalanceResponse)this.rpcService.post("get_balance", Arrays.asList(udtHash, ident), GetBalanceResponse.class);
    }

    @Override
    public TransactionCompletionResponse buildTransferTransaction(TransferPayload payload) throws IOException {
        if (payload.items.stream().anyMatch(item -> !item.to.action.equals((Object)Action.pay_by_from)) && (payload.udtHash == null || payload.udtHash == "")) {
            throw new RuntimeException("The transaction does not support ckb");
        }
        return (TransactionCompletionResponse)this.rpcService.post("build_transfer_transaction", Arrays.asList(payload), TransactionCompletionResponse.class);
    }

    @Override
    public TransactionCompletionResponse buildWalletCreationTransaction(CreateWalletPayload payload) throws IOException {
        return (TransactionCompletionResponse)this.rpcService.post("build_wallet_creation_transaction", Arrays.asList(payload), TransactionCompletionResponse.class);
    }
}

