/*
 * Decompiled with CFR 0.152.
 */
package mercury;

import com.google.gson.Gson;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import mercury.constant.AddressWithKeyHolder;
import mercury.constant.CkbNodeFactory;
import mercury.constant.MercuryApiFactory;
import model.Action;
import model.FromAccount;
import model.Source;
import model.ToAccount;
import model.TransferPayloadBuilder;
import model.resp.MercuryScriptGroup;
import model.resp.TransactionCompletionResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.transaction.ScriptGroup;
import org.nervos.ckb.transaction.Secp256k1SighashAllBuilder;
import org.nervos.ckb.type.transaction.Transaction;

public class ActionTest {
    Gson g = new Gson();

    @Test
    void transferCompletionCkbWithPayByFrom() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.from(new FromAccount(Arrays.asList(AddressWithKeyHolder.testAddress0()), Source.unconstrained));
        builder.addItem(new ToAccount(AddressWithKeyHolder.testAddress4(), Action.pay_by_from), new BigInteger("100"));
        builder.fee(new BigInteger("1000000"));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
            System.out.println(this.g.toJson((Object)s));
            Transaction tx = this.sign(s);
            String result = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void transferCompletionSudtWithPayByFrom() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.udtHash("0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd");
        builder.from(new FromAccount(Arrays.asList(AddressWithKeyHolder.testAddress1()), Source.unconstrained));
        builder.addItem(new ToAccount(AddressWithKeyHolder.testAddress2(), Action.pay_by_from), new BigInteger("100"));
        builder.fee(new BigInteger("1000000"));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
            Transaction tx = this.sign(s);
            String result = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void transferCompletionCkbWithLendByFrom() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.from(new FromAccount(Arrays.asList(AddressWithKeyHolder.testAddress1()), Source.unconstrained));
        builder.addItem(new ToAccount(AddressWithKeyHolder.testAddress2(), Action.lend_by_from), new BigInteger("100"));
        builder.fee(new BigInteger("1000000"));
        try {
            TransactionCompletionResponse transactionCompletionResponse = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"The transaction does not support ckb", (Object)e.getMessage());
        }
    }

    @Test
    void transferCompletionSudtWithLendByFrom() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.udtHash("0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd");
        builder.from(new FromAccount(Arrays.asList(AddressWithKeyHolder.testAddress1()), Source.unconstrained));
        builder.addItem(new ToAccount(AddressWithKeyHolder.testAddress2(), Action.lend_by_from), new BigInteger("100"));
        builder.fee(new BigInteger("1000000"));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
            Transaction tx = this.sign(s);
            System.out.println(this.g.toJson((Object)s.txView));
            String result = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void transferCompletionCkbWithPayByTo() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.from(new FromAccount(Arrays.asList(AddressWithKeyHolder.testAddress1()), Source.unconstrained));
        builder.addItem(new ToAccount(AddressWithKeyHolder.testAddress1(), Action.pay_by_to), new BigInteger("100"));
        builder.fee(new BigInteger("1000000"));
        try {
            TransactionCompletionResponse transactionCompletionResponse = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"The transaction does not support ckb", (Object)e.getMessage());
        }
    }

    @Test
    void transferCompletionSudtWithPayByTo() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.udtHash("0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd");
        builder.from(new FromAccount(Arrays.asList(AddressWithKeyHolder.testAddress1()), Source.unconstrained));
        builder.addItem(new ToAccount(AddressWithKeyHolder.testAddress4(), Action.pay_by_to), new BigInteger("100"));
        builder.fee(new BigInteger("1000000"));
        System.out.println(this.g.toJson((Object)builder.build()));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
            Transaction tx = this.sign(s);
            System.out.println(this.g.toJson((Object)s.txView));
            String result = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Transaction sign(TransactionCompletionResponse s) throws IOException {
        List scriptGroups = s.getScriptGroup();
        Secp256k1SighashAllBuilder signBuilder = new Secp256k1SighashAllBuilder(s.txView);
        for (MercuryScriptGroup sg : scriptGroups) {
            signBuilder.sign((ScriptGroup)sg, AddressWithKeyHolder.getKey(sg.pubKey));
        }
        Transaction tx = signBuilder.buildTx();
        return tx;
    }
}

