package mercury;

import indexer.CkbIndexerApi;
import java.io.IOException;
import java.util.List;
import model.CreateWalletPayload;
import model.TransferPayload;
import model.resp.GetBalanceResponse;
import model.resp.TransactionCompletionResponse;
import org.nervos.ckb.type.transaction.TransactionWithStatus;

public interface MercuryApi extends CkbIndexerApi {

  GetBalanceResponse getBalance(String udtHash, String ident) throws IOException;

  TransactionCompletionResponse buildTransferTransaction(TransferPayload payload)
      throws IOException;

  TransactionCompletionResponse buildWalletCreationTransaction(CreateWalletPayload payload)
      throws IOException;

  List<TransactionWithStatus> getTransactionHistory(String ident) throws IOException;
}
