/*
 * Decompiled with CFR 0.152.
 */
package mercury;

import indexer.DefaultIndexerApi;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import mercury.MercuryApi;
import model.Action;
import model.CreateWalletPayload;
import model.TransferPayload;
import model.resp.GetBalanceResponse;
import model.resp.TransactionCompletionResponse;
import org.nervos.ckb.type.transaction.TransactionWithStatus;

public class DefaultMercuryApi
extends DefaultIndexerApi
implements MercuryApi {
    public DefaultMercuryApi(String mercuryUrl, boolean isDebug) {
        super(mercuryUrl, isDebug);
    }

    @Override
    public GetBalanceResponse getBalance(String udtHash, String ident) throws IOException {
        return (GetBalanceResponse)this.rpcService.post("get_balance", Arrays.asList(udtHash, ident), GetBalanceResponse.class);
    }

    @Override
    public TransactionCompletionResponse buildTransferTransaction(TransferPayload payload) throws IOException {
        if (payload.items.stream().anyMatch(item -> !item.to.action.equals((Object)Action.pay_by_from)) && (payload.udtHash == null || payload.udtHash == "")) {
            throw new RuntimeException("The transaction does not support ckb");
        }
        return (TransactionCompletionResponse)this.rpcService.post("build_transfer_transaction", Arrays.asList(payload), TransactionCompletionResponse.class);
    }

    @Override
    public TransactionCompletionResponse buildWalletCreationTransaction(CreateWalletPayload payload) throws IOException {
        return (TransactionCompletionResponse)this.rpcService.post("build_wallet_creation_transaction", Arrays.asList(payload), TransactionCompletionResponse.class);
    }

    @Override
    public List<TransactionWithStatus> getTransactionHistory(String ident) throws IOException {
        return (List)this.rpcService.post("get_transaction_history", Arrays.asList(ident), TransactionWithStatus.class);
    }
}

