/*
 * Decompiled with CFR 0.152.
 */
package model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import model.KeyAddress;
import model.NormalAddress;
import org.nervos.ckb.address.AddressUtils;
import org.nervos.ckb.address.CodeHashType;

public abstract class QueryAddress
implements JsonSerializer<QueryAddress>,
JsonDeserializer<QueryAddress> {
    public abstract String getAddress();

    public QueryAddress deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.getAsJsonObject().has("KeyAddress")) {
            return new KeyAddress(json.getAsJsonObject().get("KeyAddress").getAsString());
        }
        return new NormalAddress(json.getAsJsonObject().get("NormalAddress").getAsString());
    }

    public static QueryAddress getQueryAddressByAddress(String address) {
        if (AddressUtils.parseAddressType((String)address) == CodeHashType.BLAKE160) {
            return new KeyAddress(address);
        }
        return new NormalAddress(address);
    }

    public JsonElement serialize(QueryAddress src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src, src.getClass());
    }
}

