/*
 * Decompiled with CFR 0.152.
 */
package mercury;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import mercury.constant.AddressWithKeyHolder;
import mercury.constant.MercuryApiFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.utils.address.AddressTools;
import org.nervos.mercury.model.GetBalancePayloadBuilder;
import org.nervos.mercury.model.req.KeyAddress;
import org.nervos.mercury.model.req.NormalAddress;
import org.nervos.mercury.model.req.QueryAddress;
import org.nervos.mercury.model.resp.GetBalanceResponse;

public class BalanceTest {
    Gson g = new GsonBuilder().registerTypeAdapter(QueryAddress.class, (Object)new KeyAddress("")).registerTypeAdapter(QueryAddress.class, (Object)new NormalAddress("")).create();

    @Test
    void getBalance() {
        try {
            GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
            builder.address(new KeyAddress(AddressWithKeyHolder.testAddress4()));
            System.out.println(this.g.toJson((Object)builder.build()));
            GetBalanceResponse balance = MercuryApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void getSudtBalance() {
        GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
        builder.address(new KeyAddress(AddressWithKeyHolder.testAddress4()));
        builder.addUdtHash("0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd");
        System.out.println(this.g.toJson((Object)builder.build()));
        try {
            GetBalanceResponse balance = MercuryApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void getAllBalance() {
        GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
        builder.address(new KeyAddress(AddressWithKeyHolder.testAddress4()));
        builder.allBalance();
        System.out.println(this.g.toJson((Object)builder.build()));
        try {
            GetBalanceResponse balance = MercuryApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
            System.out.println(balance.balances.size());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testNormalAddressWithAcpAddress() {
        GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
        builder.address(new NormalAddress(AddressTools.generateAcpAddress((String)AddressWithKeyHolder.testAddress4())));
        builder.addUdtHash("0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd");
        System.out.println(this.g.toJson((Object)builder.build()));
        try {
            GetBalanceResponse balance = MercuryApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testNormalAddressWithSecp256k1Address() {
        GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
        builder.address(new NormalAddress(AddressWithKeyHolder.testAddress4()));
        builder.addUdtHash("0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd");
        System.out.println(this.g.toJson((Object)builder.build()));
        try {
            GetBalanceResponse balance = MercuryApiFactory.getApi().getBalance(builder.build());
            Assertions.assertNotNull((Object)balance, (String)"Balance is not empty");
            System.out.println(this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

