/*
 * Decompiled with CFR 0.152.
 */
package mercury;

import com.google.gson.Gson;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import mercury.SignUtils;
import mercury.constant.AddressWithKeyHolder;
import mercury.constant.CkbNodeFactory;
import mercury.constant.MercuryApiFactory;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.mercury.model.TransferPayloadBuilder;
import org.nervos.mercury.model.req.Action;
import org.nervos.mercury.model.req.FromAddresses;
import org.nervos.mercury.model.req.FromKeyAddresses;
import org.nervos.mercury.model.req.Source;
import org.nervos.mercury.model.req.ToAddress;
import org.nervos.mercury.model.req.ToKeyAddress;
import org.nervos.mercury.model.resp.TransactionCompletionResponse;

public class FeeRateTest {
    Gson g = new Gson();

    @Test
    void defaultFeeRate() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.from((FromAddresses)new FromKeyAddresses(new HashSet<String>(Arrays.asList(AddressWithKeyHolder.testAddress0())), Source.unconstrained));
        builder.addItem((ToAddress)new ToKeyAddress(AddressWithKeyHolder.testAddress4(), Action.pay_by_from), new BigInteger("100"));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
            System.out.println(this.g.toJson((Object)s));
            Transaction tx = SignUtils.sign(s);
            String result = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void customizedFeeRate() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.from((FromAddresses)new FromKeyAddresses(new HashSet<String>(Arrays.asList(AddressWithKeyHolder.testAddress0())), Source.unconstrained));
        builder.addItem((ToAddress)new ToKeyAddress(AddressWithKeyHolder.testAddress4(), Action.pay_by_from), new BigInteger("100"));
        builder.feeRate(new BigInteger("10000"));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
            System.out.println(this.g.toJson((Object)s));
            Transaction tx = SignUtils.sign(s);
            String result = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

