/*
 * Decompiled with CFR 0.152.
 */
package mercury;

import com.google.gson.Gson;
import java.io.IOException;
import java.math.BigInteger;
import mercury.constant.MercuryApiFactory;
import org.junit.jupiter.api.Test;
import org.nervos.mercury.model.GetGenericBlockPayloadBuilder;
import org.nervos.mercury.model.resp.GenericBlockResponse;

public class GenericBlockTest {
    @Test
    void testGetGenericBlockWithBlockNumber() {
        try {
            GetGenericBlockPayloadBuilder builder = new GetGenericBlockPayloadBuilder();
            builder.blockNum(new BigInteger("2172093"));
            System.out.println(new Gson().toJson((Object)builder.build()));
            GenericBlockResponse genericBlock = MercuryApiFactory.getApi().getGenericBlock(builder.build());
            System.out.println(new Gson().toJson((Object)genericBlock));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testGetGenericBlockWithBlockHash() {
        try {
            GetGenericBlockPayloadBuilder builder = new GetGenericBlockPayloadBuilder();
            builder.blockHash("0xee8adba356105149cb9dc1cb0d09430a6bd01182868787ace587961c0d64e742");
            System.out.println(new Gson().toJson((Object)builder.build()));
            GenericBlockResponse genericBlock = MercuryApiFactory.getApi().getGenericBlock(builder.build());
            System.out.println(new Gson().toJson((Object)genericBlock));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testGetGenericBlockWithBlockHashAndBlockNumber() {
        try {
            GetGenericBlockPayloadBuilder builder = new GetGenericBlockPayloadBuilder();
            builder.blockNum(new BigInteger("2172093"));
            builder.blockHash("0xee8adba356105149cb9dc1cb0d09430a6bd01182868787ace587961c0d64e742");
            System.out.println(new Gson().toJson((Object)builder.build()));
            GenericBlockResponse genericBlock = MercuryApiFactory.getApi().getGenericBlock(builder.build());
            System.out.println(new Gson().toJson((Object)genericBlock));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testTipGenericBlock() {
        try {
            GetGenericBlockPayloadBuilder builder = new GetGenericBlockPayloadBuilder();
            System.out.println(new Gson().toJson((Object)builder.build()));
            GenericBlockResponse genericBlock = MercuryApiFactory.getApi().getGenericBlock(builder.build());
            System.out.println(new Gson().toJson((Object)genericBlock));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testBlockHashAndBlockNumberDoNotMatch() {
        try {
            GetGenericBlockPayloadBuilder builder = new GetGenericBlockPayloadBuilder();
            builder.blockNum(new BigInteger("2172092"));
            builder.blockHash("0xee8adba356105149cb9dc1cb0d09430a6bd01182868787ace587961c0d64e742");
            System.out.println(new Gson().toJson((Object)builder.build()));
            MercuryApiFactory.getApi().getGenericBlock(builder.build());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    void testCannotFind() {
        try {
            GetGenericBlockPayloadBuilder builder = new GetGenericBlockPayloadBuilder();
            builder.blockHash("0xee8adba356105149cb9dc1cb0d09430a6bd01182868787ace587961c0d64e741");
            System.out.println(new Gson().toJson((Object)builder.build()));
            MercuryApiFactory.getApi().getGenericBlock(builder.build());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    void testWrongHeight() {
        try {
            GetGenericBlockPayloadBuilder builder = new GetGenericBlockPayloadBuilder();
            builder.blockNum(new BigInteger("217209233"));
            System.out.println(new Gson().toJson((Object)builder.build()));
            MercuryApiFactory.getApi().getGenericBlock(builder.build());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

