/*
 * Decompiled with CFR 0.152.
 */
package mercury;

import com.google.gson.Gson;
import java.io.IOException;
import java.math.BigInteger;
import mercury.constant.AddressWithKeyHolder;
import mercury.constant.MercuryApiFactory;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.utils.address.AddressTools;
import org.nervos.mercury.model.QueryGenericTransactionsPayloadBuilder;
import org.nervos.mercury.model.req.KeyAddress;
import org.nervos.mercury.model.req.NormalAddress;
import org.nervos.mercury.model.resp.QueryGenericTransactionsResponse;

public class QueryGenericTransactionsPagesTest {
    Gson g = new Gson();

    @Test
    void testQueryGenericTransactionsWithCkb() {
        try {
            QueryGenericTransactionsPayloadBuilder builder = new QueryGenericTransactionsPayloadBuilder();
            builder.address(new KeyAddress(AddressWithKeyHolder.queryTransactionAddress()));
            QueryGenericTransactionsResponse resp = MercuryApiFactory.getApi().queryGenericTransactions(builder.build());
            System.out.println(resp.txs.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithUdt() {
        try {
            QueryGenericTransactionsPayloadBuilder builder = new QueryGenericTransactionsPayloadBuilder();
            builder.address(new KeyAddress(AddressWithKeyHolder.queryTransactionAddress()));
            builder.addUdtHash("0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd");
            QueryGenericTransactionsResponse resp = MercuryApiFactory.getApi().queryGenericTransactions(builder.build());
            System.out.println(resp.txs.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithAll() {
        try {
            QueryGenericTransactionsPayloadBuilder builder = new QueryGenericTransactionsPayloadBuilder();
            builder.address(new KeyAddress(AddressWithKeyHolder.queryTransactionAddress()));
            builder.allTransactionType();
            QueryGenericTransactionsResponse resp = MercuryApiFactory.getApi().queryGenericTransactions(builder.build());
            System.out.println(resp.txs.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithChequeAddress() {
        try {
            QueryGenericTransactionsPayloadBuilder builder = new QueryGenericTransactionsPayloadBuilder();
            builder.address(new NormalAddress(this.getChequeAddress()));
            builder.allTransactionType();
            QueryGenericTransactionsResponse resp = MercuryApiFactory.getApi().queryGenericTransactions(builder.build());
            System.out.println(resp.txs.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithAcpAddress() {
        try {
            QueryGenericTransactionsPayloadBuilder builder = new QueryGenericTransactionsPayloadBuilder();
            builder.address(new NormalAddress(this.getAcpAddress()));
            builder.allTransactionType();
            QueryGenericTransactionsResponse resp = MercuryApiFactory.getApi().queryGenericTransactions(builder.build());
            System.out.println(resp.txs.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithFromBlock() {
        try {
            QueryGenericTransactionsPayloadBuilder builder = new QueryGenericTransactionsPayloadBuilder();
            builder.address(new KeyAddress(AddressWithKeyHolder.queryTransactionAddress()));
            builder.allTransactionType();
            builder.fromBlock(new BigInteger("2224987"));
            QueryGenericTransactionsResponse resp = MercuryApiFactory.getApi().queryGenericTransactions(builder.build());
            System.out.println(resp.txs.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithToBlock() {
        try {
            QueryGenericTransactionsPayloadBuilder builder = new QueryGenericTransactionsPayloadBuilder();
            builder.address(new KeyAddress(AddressWithKeyHolder.queryTransactionAddress()));
            builder.allTransactionType();
            builder.toBlock(new BigInteger("2224987"));
            QueryGenericTransactionsResponse resp = MercuryApiFactory.getApi().queryGenericTransactions(builder.build());
            System.out.println(resp.txs.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithFromBlockAndToBlock() {
        try {
            QueryGenericTransactionsPayloadBuilder builder = new QueryGenericTransactionsPayloadBuilder();
            builder.address(new KeyAddress(AddressWithKeyHolder.queryTransactionAddress()));
            builder.allTransactionType();
            builder.fromBlock(new BigInteger("2224993"));
            builder.toBlock(new BigInteger("2225023"));
            QueryGenericTransactionsResponse resp = MercuryApiFactory.getApi().queryGenericTransactions(builder.build());
            System.out.println(resp.txs.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithLimit() {
        try {
            QueryGenericTransactionsPayloadBuilder builder = new QueryGenericTransactionsPayloadBuilder();
            builder.address(new KeyAddress(AddressWithKeyHolder.queryTransactionAddress()));
            builder.allTransactionType();
            builder.limit(new BigInteger("2"));
            QueryGenericTransactionsResponse resp = MercuryApiFactory.getApi().queryGenericTransactions(builder.build());
            System.out.println(resp.txs.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithOrder() {
        try {
            QueryGenericTransactionsPayloadBuilder builder = new QueryGenericTransactionsPayloadBuilder();
            builder.address(new KeyAddress(AddressWithKeyHolder.queryTransactionAddress()));
            builder.allTransactionType();
            builder.order("asc");
            QueryGenericTransactionsResponse resp = MercuryApiFactory.getApi().queryGenericTransactions(builder.build());
            System.out.println(resp.txs.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testQueryGenericTransactionsWithOffset() {
        try {
            QueryGenericTransactionsPayloadBuilder builder = new QueryGenericTransactionsPayloadBuilder();
            builder.address(new KeyAddress(AddressWithKeyHolder.queryTransactionAddress()));
            builder.allTransactionType();
            builder.limit(new BigInteger("1"));
            builder.offset(new BigInteger("1"));
            QueryGenericTransactionsResponse resp = MercuryApiFactory.getApi().queryGenericTransactions(builder.build());
            System.out.println(resp.txs.size());
            System.out.println(this.g.toJson((Object)resp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getAcpAddress() {
        return AddressTools.generateAcpAddress((String)AddressWithKeyHolder.queryTransactionAddress());
    }

    private String getChequeAddress() {
        return AddressTools.generateChequeAddress((String)AddressWithKeyHolder.testAddress0(), (String)AddressWithKeyHolder.queryTransactionAddress());
    }
}

