/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.mercury;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.nervos.ckb.service.RpcService;
import org.nervos.mercury.MercuryApi;
import org.nervos.mercury.model.req.CollectAssetPayload;
import org.nervos.mercury.model.req.CreateAssetAccountPayload;
import org.nervos.mercury.model.req.GetBalancePayload;
import org.nervos.mercury.model.req.GetGenericBlockPayload;
import org.nervos.mercury.model.req.KeyAddress;
import org.nervos.mercury.model.req.NormalAddress;
import org.nervos.mercury.model.req.QueryAddress;
import org.nervos.mercury.model.req.QueryGenericTransactionsPayload;
import org.nervos.mercury.model.req.ToKeyAddress;
import org.nervos.mercury.model.req.TransferPayload;
import org.nervos.mercury.model.resp.GenericBlockResponse;
import org.nervos.mercury.model.resp.GenericTransactionWithStatusResponse;
import org.nervos.mercury.model.resp.GetBalanceResponse;
import org.nervos.mercury.model.resp.QueryGenericTransactionsResponse;
import org.nervos.mercury.model.resp.TransactionCompletionResponse;

public class DefaultMercuryApi
implements MercuryApi {
    private RpcService rpcService;
    private Gson g = new GsonBuilder().registerTypeAdapter(QueryAddress.class, (Object)new KeyAddress("")).registerTypeAdapter(QueryAddress.class, (Object)new NormalAddress("")).create();

    public DefaultMercuryApi(String mercuryUrl, boolean isDebug) {
        this.rpcService = new RpcService(mercuryUrl, isDebug);
    }

    public DefaultMercuryApi(RpcService rpcService) {
        this.rpcService = rpcService;
    }

    @Override
    public GetBalanceResponse getBalance(GetBalancePayload payload) throws IOException {
        return (GetBalanceResponse)this.rpcService.post("get_balance", Arrays.asList(payload), GetBalanceResponse.class, this.g);
    }

    @Override
    public TransactionCompletionResponse buildTransferTransaction(TransferPayload payload) throws IOException {
        List transferItems = payload.items.stream().filter(x -> Objects.equals(x.to.getClass(), ToKeyAddress.class)).collect(Collectors.toList());
        if (transferItems.size() > 0 && payload.items.stream().anyMatch(item -> item.to.isPayByFrom() == false) && (payload.udtHash == null || payload.udtHash == "")) {
            throw new RuntimeException("The transaction does not support ckb");
        }
        return (TransactionCompletionResponse)this.rpcService.post("build_transfer_transaction", Arrays.asList(payload), TransactionCompletionResponse.class);
    }

    @Override
    public TransactionCompletionResponse buildAssetAccountCreationTransaction(CreateAssetAccountPayload payload) throws IOException {
        return (TransactionCompletionResponse)this.rpcService.post("build_asset_account_creation_transaction", Arrays.asList(payload), TransactionCompletionResponse.class);
    }

    @Override
    public GenericTransactionWithStatusResponse getGenericTransaction(String txHash) throws IOException {
        return (GenericTransactionWithStatusResponse)this.rpcService.post("get_generic_transaction", Arrays.asList(txHash), GenericTransactionWithStatusResponse.class);
    }

    @Override
    public GenericBlockResponse getGenericBlock(GetGenericBlockPayload payload) throws IOException {
        return (GenericBlockResponse)this.rpcService.post("get_generic_block", Arrays.asList(payload), GenericBlockResponse.class);
    }

    @Override
    public List<String> registerAddresses(List<String> normalAddresses) throws IOException {
        return (List)this.rpcService.post("register_addresses", Arrays.asList(normalAddresses), new TypeToken<List<String>>(){}.getType());
    }

    @Override
    public TransactionCompletionResponse buildAssetCollectionTransaction(CollectAssetPayload payload) throws IOException {
        return (TransactionCompletionResponse)this.rpcService.post("build_asset_collection_transaction", Arrays.asList(payload), TransactionCompletionResponse.class);
    }

    @Override
    public QueryGenericTransactionsResponse queryGenericTransactions(QueryGenericTransactionsPayload payload) throws IOException {
        return (QueryGenericTransactionsResponse)this.rpcService.post("query_generic_transactions", Arrays.asList(payload), QueryGenericTransactionsResponse.class);
    }
}

