/*
 * Decompiled with CFR 0.152.
 */
package mercury;

import com.google.gson.Gson;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import mercury.SignUtils;
import mercury.constant.AddressWithKeyHolder;
import mercury.constant.CkbNodeFactory;
import mercury.constant.MercuryApiFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.AmountUtils;
import org.nervos.mercury.model.TransferPayloadBuilder;
import org.nervos.mercury.model.req.Action;
import org.nervos.mercury.model.req.FromAddresses;
import org.nervos.mercury.model.req.FromKeyAddresses;
import org.nervos.mercury.model.req.Source;
import org.nervos.mercury.model.req.ToAddress;
import org.nervos.mercury.model.req.ToKeyAddress;
import org.nervos.mercury.model.resp.TransactionCompletionResponse;

public class ActionTest {
    Gson g = new Gson();

    @Test
    void transferCompletionCkbWithPayByFrom() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.from((FromAddresses)new FromKeyAddresses(new HashSet<String>(Arrays.asList(AddressWithKeyHolder.testAddress0())), Source.unconstrained));
        builder.addItem((ToAddress)new ToKeyAddress(AddressWithKeyHolder.testAddress4(), Action.pay_by_from), AmountUtils.ckbToShannon((long)100L));
        System.out.println(new Gson().toJson((Object)builder.build()));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
            System.out.println(this.g.toJson((Object)s));
            Transaction tx = this.sign(s);
            String result = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void transferCompletionSudtWithPayByFrom() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.udtHash("0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd");
        builder.from((FromAddresses)new FromKeyAddresses(new HashSet<String>(Arrays.asList(AddressWithKeyHolder.testAddress1())), Source.unconstrained));
        builder.addItem((ToAddress)new ToKeyAddress(AddressWithKeyHolder.testAddress2(), Action.pay_by_from), new BigInteger("100"));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
            Transaction tx = this.sign(s);
            String result = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void transferCompletionCkbWithLendByFrom() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.from((FromAddresses)new FromKeyAddresses(new HashSet<String>(Arrays.asList(AddressWithKeyHolder.testAddress1())), Source.unconstrained));
        builder.addItem((ToAddress)new ToKeyAddress(AddressWithKeyHolder.testAddress2(), Action.lend_by_from), AmountUtils.ckbToShannon((long)100L));
        try {
            TransactionCompletionResponse transactionCompletionResponse = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"The transaction does not support ckb", (Object)e.getMessage());
        }
    }

    @Test
    void transferCompletionSudtWithLendByFrom() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.udtHash("0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd");
        builder.from((FromAddresses)new FromKeyAddresses(new HashSet<String>(Arrays.asList(AddressWithKeyHolder.testAddress1())), Source.unconstrained));
        builder.addItem((ToAddress)new ToKeyAddress(AddressWithKeyHolder.testAddress2(), Action.lend_by_from), new BigInteger("100"));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
            Transaction tx = this.sign(s);
            System.out.println(this.g.toJson((Object)s.txView));
            String result = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void transferCompletionCkbWithPayByTo() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.from((FromAddresses)new FromKeyAddresses(new HashSet<String>(Arrays.asList(AddressWithKeyHolder.testAddress1())), Source.unconstrained));
        builder.addItem((ToAddress)new ToKeyAddress(AddressWithKeyHolder.testAddress1(), Action.pay_by_to), AmountUtils.ckbToShannon((long)100L));
        try {
            TransactionCompletionResponse transactionCompletionResponse = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"The transaction does not support ckb", (Object)e.getMessage());
        }
    }

    @Test
    void transferCompletionSudtWithPayByTo() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.udtHash("0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd");
        builder.from((FromAddresses)new FromKeyAddresses(new HashSet<String>(Arrays.asList(AddressWithKeyHolder.testAddress1())), Source.unconstrained));
        builder.addItem((ToAddress)new ToKeyAddress(AddressWithKeyHolder.testAddress4(), Action.pay_by_to), new BigInteger("100"));
        System.out.println(this.g.toJson((Object)builder.build()));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
            Transaction tx = this.sign(s);
            System.out.println(this.g.toJson((Object)s.txView));
            String result = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Transaction sign(TransactionCompletionResponse s) throws IOException {
        Transaction tx = SignUtils.sign(s);
        return tx;
    }
}

