/*
 * Decompiled with CFR 0.152.
 */
package mercury;

import com.google.common.primitives.Bytes;
import com.google.gson.Gson;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import mercury.SignUtils;
import mercury.constant.AddressWithKeyHolder;
import mercury.constant.CkbNodeFactory;
import mercury.constant.MercuryApiFactory;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.address.Network;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.AmountUtils;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.address.AddressGenerator;
import org.nervos.ckb.utils.address.AddressParseResult;
import org.nervos.ckb.utils.address.AddressParser;
import org.nervos.mercury.model.CollectAssetPayloadBuilder;
import org.nervos.mercury.model.GetBalancePayloadBuilder;
import org.nervos.mercury.model.TransferPayloadBuilder;
import org.nervos.mercury.model.req.Action;
import org.nervos.mercury.model.req.FromAddresses;
import org.nervos.mercury.model.req.FromKeyAddresses;
import org.nervos.mercury.model.req.FromNormalAddresses;
import org.nervos.mercury.model.req.Source;
import org.nervos.mercury.model.req.ToAddress;
import org.nervos.mercury.model.req.ToKeyAddress;
import org.nervos.mercury.model.req.ToNormalAddress;
import org.nervos.mercury.model.resp.AssetInfo;
import org.nervos.mercury.model.resp.GetBalanceResponse;
import org.nervos.mercury.model.resp.TransactionCompletionResponse;

public class BuildAssetCollectionTransactionTest {
    Gson g = new Gson();

    @Test
    void testFromKeyAddressAndToKeyAddressWithCkb() {
        this.sendTx();
        this.printCexCkbBalance();
        CollectAssetPayloadBuilder builder = new CollectAssetPayloadBuilder();
        builder.fromAddress((FromAddresses)new FromKeyAddresses(new HashSet<String>(Arrays.asList(AddressWithKeyHolder.cexAddress())), Source.unconstrained));
        builder.to((ToAddress)new ToKeyAddress(AddressWithKeyHolder.testAddress2(), Action.pay_by_from));
        builder.feePaidBy(AddressWithKeyHolder.testAddress4());
        System.out.println(new Gson().toJson((Object)builder.build()));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildAssetCollectionTransaction(builder.build());
            System.out.println(this.g.toJson((Object)s));
            Transaction tx = SignUtils.sign(s);
            String hash = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(hash);
            this.waitTx(hash);
            this.printCexCkbBalance();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testFromNormalAddressesWithCkb() {
        this.sendTx();
        this.printCexCkbBalance();
        CollectAssetPayloadBuilder builder = new CollectAssetPayloadBuilder();
        builder.fromAddress((FromAddresses)new FromNormalAddresses(new HashSet<String>(Arrays.asList(AddressWithKeyHolder.cexAddress()))));
        builder.to((ToAddress)new ToKeyAddress(AddressWithKeyHolder.testAddress2(), Action.pay_by_from));
        builder.feePaidBy(AddressWithKeyHolder.testAddress4());
        System.out.println(new Gson().toJson((Object)builder.build()));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildAssetCollectionTransaction(builder.build());
            System.out.println(this.g.toJson((Object)s));
            Transaction tx = SignUtils.sign(s);
            String hash = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(hash);
            this.waitTx(hash);
            this.printCexCkbBalance();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testToNormalAddressWithCkb() {
        this.sendTx();
        this.printCexCkbBalance();
        CollectAssetPayloadBuilder builder = new CollectAssetPayloadBuilder();
        builder.fromAddress((FromAddresses)new FromKeyAddresses(new HashSet<String>(Arrays.asList(AddressWithKeyHolder.cexAddress())), Source.unconstrained));
        builder.to((ToAddress)new ToNormalAddress(AddressWithKeyHolder.testAddress2()));
        builder.feePaidBy(AddressWithKeyHolder.testAddress4());
        System.out.println(new Gson().toJson((Object)builder.build()));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildAssetCollectionTransaction(builder.build());
            System.out.println(this.g.toJson((Object)s));
            Transaction tx = SignUtils.sign(s);
            String hash = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(hash);
            this.waitTx(hash);
            this.printCexCkbBalance();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testFromNormalAddressesAndToNormalAddressWithCkb() {
        this.sendTx();
        this.printCexCkbBalance();
        CollectAssetPayloadBuilder builder = new CollectAssetPayloadBuilder();
        builder.fromAddress((FromAddresses)new FromNormalAddresses(new HashSet<String>(Arrays.asList(AddressWithKeyHolder.cexAddress()))));
        builder.to((ToAddress)new ToNormalAddress(AddressWithKeyHolder.testAddress2()));
        builder.feePaidBy(AddressWithKeyHolder.testAddress4());
        System.out.println(new Gson().toJson((Object)builder.build()));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildAssetCollectionTransaction(builder.build());
            System.out.println(this.g.toJson((Object)s));
            Transaction tx = SignUtils.sign(s);
            String hash = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(hash);
            this.waitTx(hash);
            this.printCexCkbBalance();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testFromKeyAddressAndToKeyAddressWithUdt() {
        this.sendLendByFrom();
        this.printCexUdtBalance();
        CollectAssetPayloadBuilder builder = new CollectAssetPayloadBuilder();
        builder.udtHash("0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd");
        builder.fromAddress((FromAddresses)new FromKeyAddresses(new HashSet<String>(Arrays.asList(AddressWithKeyHolder.cexAddress())), Source.fleeting));
        builder.to((ToAddress)new ToKeyAddress(AddressWithKeyHolder.testAddress3(), Action.pay_by_to));
        builder.feePaidBy(AddressWithKeyHolder.testAddress4());
        System.out.println(new Gson().toJson((Object)builder.build()));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildAssetCollectionTransaction(builder.build());
            System.out.println(this.g.toJson((Object)s));
            Transaction tx = SignUtils.sign(s);
            String hash = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(hash);
            this.waitTx(hash);
            this.printCexUdtBalance();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testFromNormalAddressesWithUdt() {
        this.sendLendByFrom();
        this.printCexUdtBalance();
        CollectAssetPayloadBuilder builder = new CollectAssetPayloadBuilder();
        builder.udtHash("0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd");
        builder.fromAddress((FromAddresses)new FromNormalAddresses(new HashSet<String>(Arrays.asList(this.getChequeAddress()))));
        builder.to((ToAddress)new ToKeyAddress(AddressWithKeyHolder.testAddress3(), Action.pay_by_to));
        builder.feePaidBy(AddressWithKeyHolder.testAddress4());
        System.out.println(new Gson().toJson((Object)builder.build()));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildAssetCollectionTransaction(builder.build());
            System.out.println(this.g.toJson((Object)s));
            Transaction tx = SignUtils.sign(s);
            String hash = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(hash);
            this.waitTx(hash);
            this.printCexUdtBalance();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testToNormalAddressWithUdt() {
        this.sendLendByFrom();
        this.printCexUdtBalance();
        CollectAssetPayloadBuilder builder = new CollectAssetPayloadBuilder();
        builder.udtHash("0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd");
        builder.fromAddress((FromAddresses)new FromKeyAddresses(new HashSet<String>(Arrays.asList(AddressWithKeyHolder.cexAddress())), Source.fleeting));
        builder.to((ToAddress)new ToNormalAddress(this.getAcpAddress()));
        builder.feePaidBy(AddressWithKeyHolder.testAddress4());
        System.out.println(new Gson().toJson((Object)builder.build()));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildAssetCollectionTransaction(builder.build());
            System.out.println(this.g.toJson((Object)s));
            Transaction tx = SignUtils.sign(s);
            String hash = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(hash);
            this.waitTx(hash);
            this.printCexUdtBalance();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testFromNormalAddressesAndToNormalAddressWithUdt() {
        this.sendLendByFrom();
        this.printCexUdtBalance();
        CollectAssetPayloadBuilder builder = new CollectAssetPayloadBuilder();
        builder.udtHash("0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd");
        builder.fromAddress((FromAddresses)new FromNormalAddresses(new HashSet<String>(Arrays.asList(this.getChequeAddress()))));
        builder.to((ToAddress)new ToNormalAddress(this.getAcpAddress()));
        builder.feePaidBy(AddressWithKeyHolder.testAddress4());
        System.out.println(new Gson().toJson((Object)builder.build()));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildAssetCollectionTransaction(builder.build());
            System.out.println(this.g.toJson((Object)s));
            Transaction tx = SignUtils.sign(s);
            String hash = CkbNodeFactory.getApi().sendTransaction(tx);
            System.out.println(hash);
            this.waitTx(hash);
            this.printCexUdtBalance();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void sendLendByFrom() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.udtHash("0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd");
        builder.from((FromAddresses)new FromKeyAddresses(new HashSet<String>(Arrays.asList(AddressWithKeyHolder.testAddress0())), Source.unconstrained));
        builder.addItem((ToAddress)new ToKeyAddress(AddressWithKeyHolder.cexAddress(), Action.lend_by_from), new BigInteger("100"));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
            Transaction tx = SignUtils.sign(s);
            String hash = CkbNodeFactory.getApi().sendTransaction(tx);
            while (CkbNodeFactory.getApi().getTransaction((String)hash).txStatus.status == "pending") {
                System.out.println("Awaiting transaction results");
                TimeUnit.SECONDS.sleep(1L);
            }
            TimeUnit.SECONDS.sleep(60L);
            System.out.println("send hash of cheque cell transactions: " + hash);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private String getChequeAddress() {
        AddressParseResult senderScript = AddressParser.parse((String)AddressWithKeyHolder.testAddress0());
        AddressParseResult receiverScript = AddressParser.parse((String)AddressWithKeyHolder.cexAddress());
        System.out.println(senderScript.script.computeHash());
        System.out.println(receiverScript.script.computeHash());
        byte[] bytes = Bytes.concat((byte[][])new byte[][]{Numeric.hexStringToByteArray((String)Numeric.cleanHexPrefix((String)receiverScript.script.computeHash()).substring(0, 40)), Numeric.hexStringToByteArray((String)Numeric.cleanHexPrefix((String)senderScript.script.computeHash()).substring(0, 40))});
        String pubKey = Numeric.toHexStringNoPrefix((byte[])bytes);
        System.out.println(pubKey);
        String fullAddress = AddressGenerator.generate((Network)Network.TESTNET, (Script)new Script("0x60d5f39efce409c587cb9ea359cefdead650ca128f0bd9cb3855348f98c70d5b", pubKey, "type"));
        System.out.println(fullAddress);
        return fullAddress;
    }

    private String getAcpAddress() {
        String pubKey = "0x839f1806e85b40c13d3c73866045476cc9a8c214";
        return AddressGenerator.generate((Network)Network.TESTNET, (Script)new Script("0x3419a1c09eb2567f6552ee7a8ecffd64155cffe0f1796e6e61ec088d740c1356", pubKey, "type"));
    }

    private void printCexUdtBalance() {
        try {
            GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
            builder.address(AddressWithKeyHolder.cexAddress());
            builder.addAssetInfo(AssetInfo.newUdtAsset((String)"0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd"));
            GetBalanceResponse balance = MercuryApiFactory.getApi().getBalance(builder.build());
            System.out.printf("cex ckb balance: %s\n", this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendTx() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.from((FromAddresses)new FromKeyAddresses(new HashSet<String>(Arrays.asList(AddressWithKeyHolder.testAddress4())), Source.unconstrained));
        builder.addItem((ToAddress)new ToKeyAddress(AddressWithKeyHolder.cexAddress(), Action.pay_by_from), AmountUtils.ckbToShannon((long)100L));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
            Transaction tx = SignUtils.sign(s);
            String hash = CkbNodeFactory.getApi().sendTransaction(tx);
            this.waitTx(hash);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void waitTx(String hash) throws IOException, InterruptedException {
        while (CkbNodeFactory.getApi().getTransaction((String)hash).txStatus.status == "pending") {
            System.out.println("Awaiting transaction results");
            TimeUnit.SECONDS.sleep(1L);
        }
        TimeUnit.SECONDS.sleep(60L);
        System.out.println("send hash of transactions: " + hash);
    }

    private void printCexCkbBalance() {
        try {
            GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
            builder.address(AddressWithKeyHolder.cexAddress());
            builder.addAssetInfo(AssetInfo.newCkbAsset());
            GetBalanceResponse balance = MercuryApiFactory.getApi().getBalance(builder.build());
            System.out.printf("cex ckb balance: %s\n", this.g.toJson((Object)balance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

