/*
 * Decompiled with CFR 0.152.
 */
package mercury.normal;

import com.google.gson.Gson;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import mercury.SignUtils;
import mercury.constant.AddressWithKeyHolder;
import mercury.constant.CkbNodeFactory;
import mercury.constant.MercuryApiFactory;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.address.AddressTools;
import org.nervos.mercury.model.GetBalancePayloadBuilder;
import org.nervos.mercury.model.TransferPayloadBuilder;
import org.nervos.mercury.model.req.Action;
import org.nervos.mercury.model.req.FromAddresses;
import org.nervos.mercury.model.req.FromKeyAddresses;
import org.nervos.mercury.model.req.FromNormalAddresses;
import org.nervos.mercury.model.req.Source;
import org.nervos.mercury.model.req.ToAddress;
import org.nervos.mercury.model.req.ToKeyAddress;
import org.nervos.mercury.model.resp.AssetInfo;
import org.nervos.mercury.model.resp.GetBalanceResponse;
import org.nervos.mercury.model.resp.TransactionCompletionResponse;

public class ChequeTest {
    private String senderAddress = AddressWithKeyHolder.testAddress1();
    private String chequeCellReceiverAddress = AddressWithKeyHolder.testAddress2();
    private String receiverAddress = AddressWithKeyHolder.testAddress3();
    private String udtHash = "0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd";
    private Gson g = new Gson();

    @Test
    void test() {
        try {
            this.printBalance();
            this.issuingChequeCell();
            this.printBalance();
            this.claimChequeCell();
            this.printBalance();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printBalance() throws IOException {
        System.out.println("sender ckb balance: " + this.g.toJson((Object)this.getBalance(this.senderAddress, null)));
        System.out.println("sender udt balance: " + this.g.toJson((Object)this.getBalance(this.senderAddress, this.udtHash)));
        System.out.println("cheque cell receiver ckb balance: " + this.g.toJson((Object)this.getBalance(this.chequeCellReceiverAddress, null)));
        System.out.println("cheque cell receiver udt balance: " + this.g.toJson((Object)this.getBalance(this.chequeCellReceiverAddress, this.udtHash)));
    }

    private GetBalanceResponse getBalance(String addr, String udtHash) {
        try {
            GetBalancePayloadBuilder builder = new GetBalancePayloadBuilder();
            builder.address(addr);
            builder.addAssetInfo(AssetInfo.newUdtAsset((String)"0xf21e7350fa9518ed3cbb008e0e8c941d7e01a12181931d5608aa366ee22228bd"));
            return MercuryApiFactory.getApi().getBalance(builder.build());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void issuingChequeCell() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.udtHash(this.udtHash);
        builder.from((FromAddresses)new FromKeyAddresses(new HashSet<String>(Arrays.asList(this.senderAddress)), Source.unconstrained));
        builder.addItem((ToAddress)new ToKeyAddress(this.chequeCellReceiverAddress, Action.lend_by_from), new BigInteger("100"));
        System.out.println(new Gson().toJson((Object)builder.build()));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
            System.out.println(new Gson().toJson((Object)s));
            Transaction tx = this.sign(s);
            String hash = CkbNodeFactory.getApi().sendTransaction(tx);
            while (CkbNodeFactory.getApi().getTransaction((String)hash).txStatus.status == "pending") {
                System.out.println("Awaiting transaction results");
                TimeUnit.SECONDS.sleep(1L);
            }
            TimeUnit.SECONDS.sleep(60L);
            System.out.println("send hash of cheque cell transactions: " + hash);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void claimChequeCell() {
        TransferPayloadBuilder builder = new TransferPayloadBuilder();
        builder.udtHash(this.udtHash);
        builder.from((FromAddresses)new FromNormalAddresses(new HashSet<String>(Arrays.asList(AddressTools.generateChequeAddress((String)this.senderAddress, (String)this.chequeCellReceiverAddress)))));
        builder.addItem((ToAddress)new ToKeyAddress(this.receiverAddress, Action.pay_by_from), new BigInteger("99"));
        System.out.println(new Gson().toJson((Object)builder.build()));
        try {
            TransactionCompletionResponse s = MercuryApiFactory.getApi().buildTransferTransaction(builder.build());
            Transaction tx = this.sign(s);
            String hash = CkbNodeFactory.getApi().sendTransaction(tx);
            while (CkbNodeFactory.getApi().getTransaction((String)hash).txStatus.status == "pending") {
                System.out.println("Awaiting transaction results");
                TimeUnit.SECONDS.sleep(1L);
            }
            TimeUnit.SECONDS.sleep(60L);
            System.out.println("claim hash of cheque cell transactions: " + hash);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private Transaction sign(TransactionCompletionResponse s) throws IOException {
        Transaction tx = SignUtils.sign(s);
        return tx;
    }
}

